/*	$NetBSD: run-msyslog.c,v 1.1.1.3.8.3 2016/05/11 11:35:42 martin Exp $	*/

/* AUTOGENERATED FILE. DO NOT EDIT. */

//=======Test Runner Used To Run Each Test Below=====
#define RUN_TEST(TestFunc, TestLineNum) \
{ \
  Unity.CurrentTestName = #TestFunc; \
  Unity.CurrentTestLineNumber = TestLineNum; \
  Unity.NumberOfTests++; \
  if (TEST_PROTECT()) \
  { \
      setUp(); \
      TestFunc(); \
  } \
  if (TEST_PROTECT() && !TEST_IS_IGNORED) \
  { \
    tearDown(); \
  } \
  UnityConcludeTest(); \
}

//=======Automagically Detected Files To Include=====
#include "unity.h"
#include <setjmp.h>
#include <stdio.h>
#include "config.h"
#include "ntp_stdlib.h"

//=======External Functions This Runner Calls=====
extern void setUp(void);
extern void tearDown(void);
extern void test_msnprintf(void);
extern void test_msnprintfLiteralPercentm(void);
extern void test_msnprintfBackslashLiteralPercentm(void);
extern void test_msnprintfBackslashPercent(void);
extern void test_msnprintfHangingPercent(void);
extern void test_format_errmsgHangingPercent(void);
extern void test_msnprintfNullTarget(void);
extern void test_msnprintfTruncate(void);


//=======Test Reset Option=====
void resetTest(void);
void resetTest(void)
{
  tearDown();
  setUp();
}

char const *progname;


//=======MAIN=====
int main(int argc, char *argv[])
{
  progname = argv[0];
  UnityBegin("msyslog.c");
  RUN_TEST(test_msnprintf, 14);
  RUN_TEST(test_msnprintfLiteralPercentm, 15);
  RUN_TEST(test_msnprintfBackslashLiteralPercentm, 16);
  RUN_TEST(test_msnprintfBackslashPercent, 17);
  RUN_TEST(test_msnprintfHangingPercent, 18);
  RUN_TEST(test_format_errmsgHangingPercent, 19);
  RUN_TEST(test_msnprintfNullTarget, 20);
  RUN_TEST(test_msnprintfTruncate, 21);

  return (UnityEnd());
}
