/*	$NetBSD: run-statestr.c,v 1.1.1.3.8.3 2016/05/11 11:35:42 martin Exp $	*/

/* AUTOGENERATED FILE. DO NOT EDIT. */

//=======Test Runner Used To Run Each Test Below=====
#define RUN_TEST(TestFunc, TestLineNum) \
{ \
  Unity.CurrentTestName = #TestFunc; \
  Unity.CurrentTestLineNumber = TestLineNum; \
  Unity.NumberOfTests++; \
  if (TEST_PROTECT()) \
  { \
      setUp(); \
      TestFunc(); \
  } \
  if (TEST_PROTECT() && !TEST_IS_IGNORED) \
  { \
    tearDown(); \
  } \
  UnityConcludeTest(); \
}

//=======Automagically Detected Files To Include=====
#include "unity.h"
#include <setjmp.h>
#include <stdio.h>
#include "config.h"
#include "ntp_stdlib.h"
#include "ntp.h"
#include "ntp_control.h"

//=======External Functions This Runner Calls=====
extern void setUp(void);
extern void tearDown(void);
extern void test_PeerRestart(void);
extern void test_SysUnspecified(void);
extern void test_ClockCodeExists(void);
extern void test_ClockCodeUnknown(void);


//=======Test Reset Option=====
void resetTest(void);
void resetTest(void)
{
  tearDown();
  setUp();
}

char const *progname;


//=======MAIN=====
int main(int argc, char *argv[])
{
  progname = argv[0];
  UnityBegin("statestr.c");
  RUN_TEST(test_PeerRestart, 10);
  RUN_TEST(test_SysUnspecified, 11);
  RUN_TEST(test_ClockCodeExists, 12);
  RUN_TEST(test_ClockCodeUnknown, 13);

  return (UnityEnd());
}
