/*	$NetBSD: run-leapsec.c,v 1.1.1.1.8.3 2016/05/11 11:35:43 martin Exp $	*/

/* AUTOGENERATED FILE. DO NOT EDIT. */

//=======Test Runner Used To Run Each Test Below=====
#define RUN_TEST(TestFunc, TestLineNum) \
{ \
  Unity.CurrentTestName = #TestFunc; \
  Unity.CurrentTestLineNumber = TestLineNum; \
  Unity.NumberOfTests++; \
  if (TEST_PROTECT()) \
  { \
      setUp(); \
      TestFunc(); \
  } \
  if (TEST_PROTECT() && !TEST_IS_IGNORED) \
  { \
    tearDown(); \
  } \
  UnityConcludeTest(); \
}

//=======Automagically Detected Files To Include=====
#include "unity.h"
#include <setjmp.h>
#include <stdio.h>
#include "config.h"
#include "ntp.h"
#include "ntp_calendar.h"
#include "ntp_stdlib.h"
#include "ntp_leapsec.h"
#include "test-libntp.h"
#include <string.h>

//=======External Functions This Runner Calls=====
extern void setUp(void);
extern void tearDown(void);
extern void test_ValidateGood(void);
extern void test_ValidateNoHash(void);
extern void test_ValidateBad(void);
extern void test_ValidateMalformed(void);
extern void test_ValidateMalformedShort(void);
extern void test_ValidateNoLeadZero(void);
extern void test_tableSelect(void);
extern void test_loadFileExpire(void);
extern void test_loadFileTTL(void);
extern void test_lsQueryPristineState(void);
extern void test_ls2009faraway(void);
extern void test_ls2009weekaway(void);
extern void test_ls2009houraway(void);
extern void test_ls2009secaway(void);
extern void test_ls2009onspot(void);
extern void test_ls2009nodata(void);
extern void test_ls2009limdata(void);
extern void test_qryJumpFarAhead(void);
extern void test_qryJumpAheadToTransition(void);
extern void test_qryJumpAheadOverTransition(void);
extern void test_addDynamic(void);
extern void test_taiEmptyTable(void);
extern void test_taiTableFixed(void);
extern void test_taiTableDynamic(void);
extern void test_taiTableDynamicDeadZone(void);
extern void test_ls2009seqInsElectric(void);
extern void test_ls2009seqInsDumb(void);
extern void test_ls2009seqDelElectric(void);
extern void test_ls2009seqDelDumb(void);
extern void test_ls2012seqInsElectric(void);
extern void test_ls2012seqInsDumb(void);
extern void test_lsEmptyTableDumb(void);
extern void test_lsEmptyTableElectric(void);


//=======Test Reset Option=====
void resetTest(void);
void resetTest(void)
{
  tearDown();
  setUp();
}

char const *progname;


//=======MAIN=====
int main(int argc, char *argv[])
{
  progname = argv[0];
  UnityBegin("leapsec.c");
  RUN_TEST(test_ValidateGood, 351);
  RUN_TEST(test_ValidateNoHash, 362);
  RUN_TEST(test_ValidateBad, 373);
  RUN_TEST(test_ValidateMalformed, 385);
  RUN_TEST(test_ValidateMalformedShort, 397);
  RUN_TEST(test_ValidateNoLeadZero, 409);
  RUN_TEST(test_tableSelect, 426);
  RUN_TEST(test_loadFileExpire, 466);
  RUN_TEST(test_loadFileTTL, 487);
  RUN_TEST(test_lsQueryPristineState, 522);
  RUN_TEST(test_ls2009faraway, 538);
  RUN_TEST(test_ls2009weekaway, 559);
  RUN_TEST(test_ls2009houraway, 580);
  RUN_TEST(test_ls2009secaway, 601);
  RUN_TEST(test_ls2009onspot, 622);
  RUN_TEST(test_ls2009nodata, 643);
  RUN_TEST(test_ls2009limdata, 664);
  RUN_TEST(test_qryJumpFarAhead, 689);
  RUN_TEST(test_qryJumpAheadToTransition, 712);
  RUN_TEST(test_qryJumpAheadOverTransition, 737);
  RUN_TEST(test_addDynamic, 767);
  RUN_TEST(test_taiEmptyTable, 961);
  RUN_TEST(test_taiTableFixed, 974);
  RUN_TEST(test_taiTableDynamic, 990);
  RUN_TEST(test_taiTableDynamicDeadZone, 1020);
  RUN_TEST(test_ls2009seqInsElectric, 1044);
  RUN_TEST(test_ls2009seqInsDumb, 1091);
  RUN_TEST(test_ls2009seqDelElectric, 1143);
  RUN_TEST(test_ls2009seqDelDumb, 1190);
  RUN_TEST(test_ls2012seqInsElectric, 1236);
  RUN_TEST(test_ls2012seqInsDumb, 1283);
  RUN_TEST(test_lsEmptyTableDumb, 1336);
  RUN_TEST(test_lsEmptyTableElectric, 1365);

  return (UnityEnd());
}
