/*	$NetBSD: certificate.h,v 1.1.1.2 2010/03/08 02:14:14 lukem Exp $	*/


#include "asn-incl.h"
/*
 *    certificate.h
 *    "AuthenticationFramework" ASN.1 module encode/decode/extracting/matching/free C src.
 *    This file was generated by modified eSMACC compiler Sat Dec 11 11:22:49 2004
 *    The generated files are strongly encouraged to be
 *    compiled as a module for OpenLDAP Software
 */

#ifndef _certificate_h_
#define _certificate_h_




#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#pragma warning( disable : 4101 )
#endif
#include "componentlib.h"
typedef enum AuthenticationFrameworkAnyId
{
    nullOid_ANY_ID = 0,
    nullOid2_ANY_ID = 1,
    nullOid3_ANY_ID = 2,
    printableStringOid_ANY_ID = 3,
    printableStringOid2_ANY_ID = 4,
    printableStringOid3_ANY_ID = 5,
    printableStringOid4_ANY_ID = 6,
    printableStringOid5_ANY_ID = 7,
    printableStringOid6_ANY_ID = 8,
    printableStringOid7_ANY_ID = 9,
    iA5StringOid_ANY_ID = 10,
    octetStringOid_ANY_ID = 11,
    octetStringOid2_ANY_ID = 12,
    octetStringOid3_ANY_ID = 13,
    octetStringOid4_ANY_ID = 14,
    octetStringOid5_ANY_ID = 15,
    octetStringOid7_ANY_ID = 17} AuthenticationFrameworkAnyId;

void InitAnyAuthenticationFramework();


#define V1 0
#define V2 1
#define V3 2

typedef ComponentInt ComponentVersion; /* INTEGER { V1 (0), V2 (1), V3 (2) }  */

#define MatchingComponentVersion MatchingComponentInt

#define ExtractingComponentVersion ExtractingComponentInt

#define BDecComponentVersion BDecComponentInt

#define GDecComponentVersion GDecComponentInt


typedef ComponentInt ComponentCertificateSerialNumber; /* INTEGER */

#define MatchingComponentCertificateSerialNumber MatchingComponentInt

#define ExtractingComponentCertificateSerialNumber ExtractingComponentInt

#define BDecComponentCertificateSerialNumber BDecComponentInt

#define GDecComponentCertificateSerialNumber GDecComponentInt


typedef ComponentOid ComponentAttributeType; /* OBJECT IDENTIFIER */

#define MatchingComponentAttributeType MatchingComponentOid

#define ExtractingComponentAttributeType ExtractingComponentOid

#define BDecComponentAttributeType BDecComponentOid

#define GDecComponentAttributeType GDecComponentOid


typedef ComponentBits ComponentUniqueIdentifier; /* BIT STRING */

#define MatchingComponentUniqueIdentifier MatchingComponentBits

#define ExtractingComponentUniqueIdentifier ExtractingComponentBits

#define BDecComponentUniqueIdentifier BDecComponentBits

#define GDecComponentUniqueIdentifier GDecComponentBits


typedef struct AlgorithmIdentifier /* SEQUENCE */
{
	Syntax* syntax;
	ComponentDesc* comp_desc;
	struct berval identifier;
	char id_buf[MAX_IDENTIFIER_LEN];
	ComponentOid algorithm; /* OBJECT IDENTIFIER */
	ComponentAnyDefinedBy parameters; /* ANY DEFINED BY algorithm OPTIONAL */
} ComponentAlgorithmIdentifier;

int MatchingComponentAlgorithmIdentifier PROTO (( char *oid, ComponentSyntaxInfo *, ComponentSyntaxInfo *v2 ));


void* ExtractingComponentAlgorithmIdentifier PROTO (( void* mem_op, ComponentReference *cr, ComponentAlgorithmIdentifier *comp ));


int BDecComponentAlgorithmIdentifier PROTO ((void* mem_op, GenBuf * b, AsnTag tagId0, AsnLen elmtLen0, ComponentAlgorithmIdentifier **v, AsnLen *bytesDecoded, int mode));


int GDecComponentAlgorithmIdentifier PROTO (( void* mem_op, GenBuf * b, ComponentAlgorithmIdentifier **v, AsnLen *bytesDecoded, int mode));



typedef struct Time /* CHOICE */
{
	Syntax* syntax;
	ComponentDesc* comp_desc;
	struct berval identifier;
	char id_buf[MAX_IDENTIFIER_LEN];
    enum TimeChoiceId
    {
        TIME_UTCTIME,
        TIME_GENERALIZEDTIME
    } choiceId;
    union TimeChoiceUnion
    {
	ComponentUTCTime* utcTime; /* < unknown type id ?! > */
	ComponentGeneralizedTime* generalizedTime; /* < unknown type id ?! > */
    } a;
} ComponentTime;

int MatchingComponentTime PROTO (( char *oid, ComponentSyntaxInfo *, ComponentSyntaxInfo *v2 ));


void* ExtractingComponentTime PROTO (( void* mem_op, ComponentReference *cr, ComponentTime *comp ));


int BDecComponentTime PROTO ((void* mem_op, GenBuf * b, AsnTag tagId0, AsnLen elmtLen0, ComponentTime **v, AsnLen *bytesDecoded, int mode));


int GDecComponentTime PROTO (( void* mem_op, GenBuf * b, ComponentTime **v, AsnLen *bytesDecoded, int mode));



typedef struct Extension /* SEQUENCE */
{
	Syntax* syntax;
	ComponentDesc* comp_desc;
	struct berval identifier;
	char id_buf[MAX_IDENTIFIER_LEN];
	ComponentOid extnID; /* OBJECT IDENTIFIER */
	ComponentBool* critical; /* BOOLEAN DEFAULT FALSE */
	ComponentOcts extnValue; /* OCTET STRING */
} ComponentExtension;

int MatchingComponentExtension PROTO (( char *oid, ComponentSyntaxInfo *, ComponentSyntaxInfo *v2 ));


void* ExtractingComponentExtension PROTO (( void* mem_op, ComponentReference *cr, ComponentExtension *comp ));


int BDecComponentExtension PROTO ((void* mem_op, GenBuf * b, AsnTag tagId0, AsnLen elmtLen0, ComponentExtension **v, AsnLen *bytesDecoded, int mode));


int GDecComponentExtension PROTO (( void* mem_op, GenBuf * b, ComponentExtension **v, AsnLen *bytesDecoded, int mode));



typedef struct AttributeTypeAndValue /* SEQUENCE */
{
	Syntax* syntax;
	ComponentDesc* comp_desc;
	struct berval identifier;
	char id_buf[MAX_IDENTIFIER_LEN];
	ComponentAttributeType type; /* AttributeType */
	ComponentAnyDefinedBy value; /* ANY DEFINED BY type */
} ComponentAttributeTypeAndValue;

int MatchingComponentAttributeTypeAndValue PROTO (( char *oid, ComponentSyntaxInfo *, ComponentSyntaxInfo *v2 ));


void* ExtractingComponentAttributeTypeAndValue PROTO (( void* mem_op, ComponentReference *cr, ComponentAttributeTypeAndValue *comp ));


int BDecComponentAttributeTypeAndValue PROTO ((void* mem_op, GenBuf * b, AsnTag tagId0, AsnLen elmtLen0, ComponentAttributeTypeAndValue **v, AsnLen *bytesDecoded, int mode));


int GDecComponentAttributeTypeAndValue PROTO (( void* mem_op, GenBuf * b, ComponentAttributeTypeAndValue **v, AsnLen *bytesDecoded, int mode));



typedef struct Validity /* SEQUENCE */
{
	Syntax* syntax;
	ComponentDesc* comp_desc;
	struct berval identifier;
	char id_buf[MAX_IDENTIFIER_LEN];
	ComponentTime* notBefore; /* Time */
	ComponentTime* notAfter; /* Time */
} ComponentValidity;

int MatchingComponentValidity PROTO (( char *oid, ComponentSyntaxInfo *, ComponentSyntaxInfo *v2 ));


void* ExtractingComponentValidity PROTO (( void* mem_op, ComponentReference *cr, ComponentValidity *comp ));


int BDecComponentValidity PROTO ((void* mem_op, GenBuf * b, AsnTag tagId0, AsnLen elmtLen0, ComponentValidity **v, AsnLen *bytesDecoded, int mode));


int GDecComponentValidity PROTO (( void* mem_op, GenBuf * b, ComponentValidity **v, AsnLen *bytesDecoded, int mode));



typedef struct SubjectPublicKeyInfo /* SEQUENCE */
{
	Syntax* syntax;
	ComponentDesc* comp_desc;
	struct berval identifier;
	char id_buf[MAX_IDENTIFIER_LEN];
	ComponentAlgorithmIdentifier* algorithm; /* AlgorithmIdentifier */
	ComponentBits subjectPublicKey; /* BIT STRING */
} ComponentSubjectPublicKeyInfo;

int MatchingComponentSubjectPublicKeyInfo PROTO (( char *oid, ComponentSyntaxInfo *, ComponentSyntaxInfo *v2 ));


void* ExtractingComponentSubjectPublicKeyInfo PROTO (( void* mem_op, ComponentReference *cr, ComponentSubjectPublicKeyInfo *comp ));


int BDecComponentSubjectPublicKeyInfo PROTO ((void* mem_op, GenBuf * b, AsnTag tagId0, AsnLen elmtLen0, ComponentSubjectPublicKeyInfo **v, AsnLen *bytesDecoded, int mode));


int GDecComponentSubjectPublicKeyInfo PROTO (( void* mem_op, GenBuf * b, ComponentSubjectPublicKeyInfo **v, AsnLen *bytesDecoded, int mode));



typedef ComponentList ComponentExtensions; /* SEQUENCE SIZE 1..MAX OF Extension */

int MatchingComponentExtensions PROTO (( char *oid, ComponentSyntaxInfo *, ComponentSyntaxInfo *v2 ));


void* ExtractingComponentExtensions PROTO (( void* mem_op, ComponentReference *cr, ComponentExtensions *comp ));


int BDecComponentExtensions PROTO ((void* mem_op, GenBuf * b, AsnTag tagId0, AsnLen elmtLen0, ComponentExtensions **v, AsnLen *bytesDecoded, int mode));


int GDecComponentExtensions PROTO (( void* mem_op, GenBuf * b, ComponentExtensions **v, AsnLen *bytesDecoded, int mode));



typedef ComponentList ComponentRelativeDistinguishedName; /* SET OF AttributeTypeAndValue */

int MatchingComponentRelativeDistinguishedName PROTO (( char *oid, ComponentSyntaxInfo *, ComponentSyntaxInfo *v2 ));


void* ExtractingComponentRelativeDistinguishedName PROTO (( void* mem_op, ComponentReference *cr, ComponentRelativeDistinguishedName *comp ));


int BDecComponentRelativeDistinguishedName PROTO ((void* mem_op, GenBuf * b, AsnTag tagId0, AsnLen elmtLen0, ComponentRelativeDistinguishedName **v, AsnLen *bytesDecoded, int mode));


int GDecComponentRelativeDistinguishedName PROTO (( void* mem_op, GenBuf * b, ComponentRelativeDistinguishedName **v, AsnLen *bytesDecoded, int mode));



typedef ComponentList ComponentRDNSequence; /* SEQUENCE OF RelativeDistinguishedName */

int MatchingComponentRDNSequence PROTO (( char *oid, ComponentSyntaxInfo *, ComponentSyntaxInfo *v2 ));


void* ExtractingComponentRDNSequence PROTO (( void* mem_op, ComponentReference *cr, ComponentRDNSequence *comp ));


int BDecComponentRDNSequence PROTO ((void* mem_op, GenBuf * b, AsnTag tagId0, AsnLen elmtLen0, ComponentRDNSequence **v, AsnLen *bytesDecoded, int mode));


int GDecComponentRDNSequence PROTO (( void* mem_op, GenBuf * b, ComponentRDNSequence **v, AsnLen *bytesDecoded, int mode));



typedef struct Name /* CHOICE */
{
	Syntax* syntax;
	ComponentDesc* comp_desc;
	struct berval identifier;
	char id_buf[MAX_IDENTIFIER_LEN];
    enum NameChoiceId
    {
        NAME_RDNSEQUENCE
    } choiceId;
    union NameChoiceUnion
    {
	ComponentRDNSequence* rdnSequence; /* RDNSequence */
    } a;
} ComponentName;

int MatchingComponentName PROTO (( char *oid, ComponentSyntaxInfo *, ComponentSyntaxInfo *v2 ));


void* ExtractingComponentName PROTO (( void* mem_op, ComponentReference *cr, ComponentName *comp ));


int BDecComponentName PROTO ((void* mem_op, GenBuf * b, AsnTag tagId0, AsnLen elmtLen0, ComponentName **v, AsnLen *bytesDecoded, int mode));


int GDecComponentName PROTO (( void* mem_op, GenBuf * b, ComponentName **v, AsnLen *bytesDecoded, int mode));



typedef struct TBSCertificate /* SEQUENCE */
{
	Syntax* syntax;
	ComponentDesc* comp_desc;
	struct berval identifier;
	char id_buf[MAX_IDENTIFIER_LEN];
	ComponentVersion* version; /* [0] Version DEFAULT v1 */
	ComponentCertificateSerialNumber serialNumber; /* CertificateSerialNumber */
	ComponentAlgorithmIdentifier* signature; /* AlgorithmIdentifier */
	ComponentName* issuer; /* Name */
	ComponentValidity* validity; /* Validity */
	ComponentName* subject; /* Name */
	ComponentSubjectPublicKeyInfo* subjectPublicKeyInfo; /* SubjectPublicKeyInfo */
	ComponentUniqueIdentifier issuerUniqueIdentifier; /* [1] IMPLICIT UniqueIdentifier OPTIONAL */
	ComponentUniqueIdentifier subjectUniqueIdentifier; /* [2] IMPLICIT UniqueIdentifier OPTIONAL */
	ComponentExtensions* extensions; /* [3] Extensions OPTIONAL */
} ComponentTBSCertificate;

int MatchingComponentTBSCertificate PROTO (( char *oid, ComponentSyntaxInfo *, ComponentSyntaxInfo *v2 ));


void* ExtractingComponentTBSCertificate PROTO (( void* mem_op, ComponentReference *cr, ComponentTBSCertificate *comp ));


int BDecComponentTBSCertificate PROTO ((void* mem_op, GenBuf * b, AsnTag tagId0, AsnLen elmtLen0, ComponentTBSCertificate **v, AsnLen *bytesDecoded, int mode));


int GDecComponentTBSCertificate PROTO (( void* mem_op, GenBuf * b, ComponentTBSCertificate **v, AsnLen *bytesDecoded, int mode));



typedef struct Certificate /* SEQUENCE */
{
	Syntax* syntax;
	ComponentDesc* comp_desc;
	struct berval identifier;
	char id_buf[MAX_IDENTIFIER_LEN];
	ComponentTBSCertificate* toBeSigned; /* TBSCertificate */
	ComponentAlgorithmIdentifier* signatureAlgorithm; /* AlgorithmIdentifier */
	ComponentBits signature; /* BIT STRING */
} ComponentCertificate;

int MatchingComponentCertificate PROTO (( char *oid, ComponentSyntaxInfo *, ComponentSyntaxInfo *v2 ));


void* ExtractingComponentCertificate PROTO (( void* mem_op, ComponentReference *cr, ComponentCertificate *comp ));


int BDecComponentCertificate PROTO ((void* mem_op, GenBuf * b, AsnTag tagId0, AsnLen elmtLen0, ComponentCertificate **v, AsnLen *bytesDecoded, int mode));


int GDecComponentCertificate PROTO (( void* mem_op, GenBuf * b, ComponentCertificate **v, AsnLen *bytesDecoded, int mode));



/* ========== Object Declarations ========== */


/* ========== Object Set Declarations ========== */
#ifdef __cplusplus
extern "C" {
#endif

#endif /* conditional include of certificate.h */
