#!/bin/sh
#
# Generate slides for a S5 presentation using a simplified control file
#
# Valid control words for the control file are:
#
# author <author> - defines the author name
# presdate <date>   - defines the presentation date
# company <company> - defines the company affiliation (for meta data)
# title <title> - defines the title of the talk
# slide <title> - begins a slide with the given title
# footer <footer> - defines the footer text
# h3 <text>     - puts text inside <H3></H3>
# *             - bullet point
# **		- second level bullet point
# include <file> - insert the contents of the given file into the presentation
#                  the file must be self contained an not change the state
#                  of the presentation output (ie if a slide is started it
#                  must be closed etc)
#
# note that author, date, company, footer and title must be defined before
# before the first slide because they are used in the metadata.
#
cat $1 | awk '

function preamble() {
	printf "<title>%s</title>\n", title
	print "<!-- metadata -->"
	print "<meta name=\"generator\" content=\"S5\" />"
	print "<meta name=\"version\" content=\"S5 1.1\" />"
	printf "<meta name=\"presdate\" content=\"%s\" />\n", presdate
	printf "<meta name=\"author\" content=\"%s\" />\n", author
	printf "<meta name=\"company\" content=\"%s\" />\n", company
	print "<!-- configuration parameters -->"
	print "<meta name=\"defaultView\" content=\"slideshow\" />"
	print "<meta name=\"controlVis\" content=\"hidden\" />"
	print "<!-- style sheet links -->"
	print "<link rel=\"stylesheet\" href=\"ui/default/slides.css\" type=\"text/css\" media=\"projection\" id=\"slideProj\" />"
	print "<link rel=\"stylesheet\" href=\"ui/default/outline.css\" type=\"text/css\" media=\"screen\" id=\"outlineStyle\" />"
	print "<link rel=\"stylesheet\" href=\"ui/default/print.css\" type=\"text/css\" media=\"print\" id=\"slidePrint\" />"
	print "<link rel=\"stylesheet\" href=\"ui/default/opera.css\" type=\"text/css\" media=\"projection\" id=\"operaFix\" />"
	print "<!-- embedded styles -->"
	print "<style type=\"text/css\" media=\"all\">"
	print ".imgcon {width: 525px; margin: 0 auto; padding: 0; text-align: center;}"
	print "#anim {width: 270px; height: 320px; position: relative; margin-top: 0.5em;}"
	print "#anim img {position: absolute; top: 42px; left: 24px;}"
	print "img#me01 {top: 0; left: 0;}"
	print "img#me02 {left: 23px;}"
	print "img#me04 {top: 44px;}"
	print "img#me05 {top: 43px;left: 36px;}"
	print "</style>"
	print "<!-- S5 JS -->"
	print "<script src=\"ui/default/slides.js\" type=\"text/javascript\"></script>"
	print "</head>"
	print "<body>"
	print ""
	print "<div class=\"layout\">"
	print "<div id=\"controls\"><!-- DO NOT EDIT --></div>"
	print "<div id=\"currentSlide\"><!-- DO NOT EDIT --></div>"
	print "<div id=\"header\"></div>"
	print "<div id=\"footer\">"
	printf "<h1>%s</h1>", footer
	print "</div>"
	print ""
	print "</div>"
	print "<div class=\"presentation\">"
	print ""
}

function emit_title() {
	print "<div class=\"slide\">"
	printf "<h1>%s</h1><br>\n", title
	printf "<h3>%s</h3>", author
	print "</div>"
	print ""
}

BEGIN {
	in_slide=0
	in_list=0
	in_second_list = 0
	done_title = 0
	author = "someone who forgot the author line"
	presdate = "no date"
	company = "forgot the company line"
	title = "forgot the title"
	footer = "NetBSD"

	print "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" "
	print "        \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">"
	print ""
	print "<html xmlns=\"http://www.w3.org/1999/xhtml\">"
	print ""
	print "<head>"
}

{
	line = $0
	if ($1 == "author") {
		sub(/^[ \t]*author[ \t]*/,"", line)
		author = line
	}

	if ($1 == "title") {
		sub(/^[ \t]*title[ \t]*/,"", line)
		title = line
	}

	if ($1 == "presdate") {
		sub(/^[ \t]*presdate[ \t]*/,"", line)
		presdate = line
	}

	if ($1 == "company") {
		sub(/^[ \t]*company[ \t]*/,"", line)
		company = line
	}

	if ($1 == "footer") {
		sub(/^[ \t]*footer[ \t]*/,"", line)
		footer = line
	}

	if ($1 == "include") {
		sub(/^[ \t]*include[ \t]*/,"", line)
		while (getline < line) {
			print $0
		}
	}

	if ($1 == "slide") {
		if (done_title == 0) {
			preamble()
			emit_title()
			done_title = 1
		}

		if (in_second_list == 1) {
			print "</ul>"
			in_second_list = 0
		}

		if (in_list == 1) {
			print "</ul>"
			in_list = 0
		}

		if (in_slide == 1) {
			print "</div>"
			print ""
		}

		print "<div class=\"slide\">"
		sub(/^[ \t]*slide[ \t]*/,"", line)
		printf "<h1>%s</h1>\n", line
		in_slide = 1
	}

	if ($1 == "**") {
		if (in_list == 0) {
			print "<ul>"
			in_list = 1
		}

		if (in_second_list == 0) {
			print "<ul>"
			in_second_list = 1
		}

		sub(/^[ \t]*\*\*[ \t]*/,"", line)
		printf "<li>%s</li>\n", line
	}

	if ($1 == "*") {
		if (in_second_list == 1) {
			print "</ul>"
			in_second_list = 0
		}

		if (in_list == 0) {
			print "<ul>"
			in_list = 1
		}

		sub(/^[ \t]*\*[ \t]*/,"", line)
		printf "<li>%s</li>\n", line
	}

	if ($1 == "h3") {
		sub(/^[ \t]*\h3[ \t]*/,"", line)
		printf "<h3>%s</h3>\n", line
	}
}

END {
	if (in_second_list == 1) {
		print "</ul>"
	}

	if (in_list == 1) {
		print "</ul>"
	}

	if (in_slide == 1) {
		print "</div>"
		print ""
	}

	print "</div>"
	print ""
	print "</body>"
	print "</html>"
}
'
