/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.compareRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.codec.decorators.CompareRequestDecorator;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.CompareResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreCompareRequestAttributeDesc
extends GrammarAction<LdapMessageContainer<CompareRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreCompareRequestAttributeDesc.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreCompareRequestAttributeDesc() {
        super("Store CompareRequest assertion description");
    }

    public void action(LdapMessageContainer<CompareRequestDecorator> container) throws DecoderException {
        CompareRequest compareRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_04093, (Object[])new Object[0]);
            LOG.error(msg);
            CompareResponseImpl response = new CompareResponseImpl(compareRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, compareRequest.getName(), null);
        }
        String type = Strings.utf8ToString((byte[])tlv.getValue().getData());
        compareRequest.setAttributeId(type);
        if (IS_DEBUG) {
            LOG.debug("Comparing attribute description {}", (Object)compareRequest.getAttributeId());
        }
    }
}

