/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.serializer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.mavibot.btree.comparator.ByteComparator;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;

public class ByteSerializer
extends AbstractElementSerializer<Byte> {
    public ByteSerializer() {
        super(new ByteComparator());
    }

    @Override
    public byte[] serialize(Byte element) {
        byte[] bytes = new byte[1];
        return ByteSerializer.serialize(bytes, 0, element);
    }

    public static byte[] serialize(byte value) {
        byte[] bytes = new byte[1];
        return ByteSerializer.serialize(bytes, 0, value);
    }

    public static byte[] serialize(byte[] buffer, int start, byte value) {
        buffer[start] = value;
        return buffer;
    }

    public static Byte deserialize(byte[] in) {
        return ByteSerializer.deserialize(in, 0);
    }

    public static Byte deserialize(byte[] in, int start) {
        if (in == null || in.length < 1 + start) {
            throw new RuntimeException("Cannot extract a Byte from a buffer with not enough bytes");
        }
        return in[start];
    }

    @Override
    public Byte deserialize(ByteBuffer buffer) throws IOException {
        return buffer.get();
    }

    @Override
    public Byte deserialize(BufferHandler bufferHandler) throws IOException {
        byte[] in = bufferHandler.read(1);
        return ByteSerializer.deserialize(in);
    }
}

