#include <stdio.h>
#include <stdlib.h>
#include <ucontext.h>

/* Context test 6: makecontext() and _swapcontext_u() */

void contextfunc(int *val, ucontext_t *self, ucontext_t *uc);

int main(void)
{

	ucontext_t u, v;
	volatile int x;
	int stacksize = 1<<18;
	void *stackbase;

	x = 0;

	printf("Start\n");


	x = 20;

	getcontext(&u); /* Necessary for initialization */

	stackbase = malloc(stacksize);

	/* XXX Solaris interprets the stack as covering the range
	 * (ss_sp - ss_size, ss_sp], rather than [ss_sp, ss_sp+ss_size), as 
	 * mandated by SUSv2 and Solaris's own setaltstack() man page.
	 */
	u.uc_stack.ss_sp = ((char *)stackbase) + stacksize/2;
	u.uc_stack.ss_size = stacksize/2;
	u.uc_link = NULL;

	/* The SUSv2 man page for makecontext says:
	 * The value of argc must match the number of integer
	 * arguments passed to func, otherwise the behaviour is
	 * undefined.
	 *
	 * Irix and Digital Unix say roughly the same thing.
	 *
	 * Solaris says:
	 * The integer value of argc must be one-greater-than the
	 * number of arguments that follow argc; otherwise, the
	 * behavior is undefined.  For 5 arguments, the value of argc
	 * must be 6.
	 *
	 * The NetBSD implementation follows Solaris. :/
	 *
	 * Fortunately, Irix and Digital Unix seem not to blow up if you
	 * pass in a value that's one greater.
	 */

	makecontext(&u, contextfunc, 4, &x, &u, &v);

	printf("About to swap to coroutine. x = %d\n", x);

	_swapcontext_u(&v, &u);

	printf("Returned from coroutine. x = %d\n", x);

	x *= 2;

	printf("About to swap to coroutine again. x = %d\n", x);
	_swapcontext_u(&v, &u);

	printf("Returned from coroutine again. x = %d\n", x);

	printf("End\n");

	return 0;
}

void contextfunc(int *val, ucontext_t *self, ucontext_t *uc)
{
	char buf[100];

	printf("Context coroutine started. *val = %d\n", *val);

	*val *= 2;

	printf("About to swap back to main routine.\n");
	
	_swapcontext_u(self, uc);

	printf("Returned to coroutine. *val = %d\n", *val);

	*val *= 2;

	printf("About to swap back to main routine again.\n");
	_swapcontext_u(self, uc);
}
		
