
#include <errno.h>
#include <fcntl.h>
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/uio.h>


void *threadfunc(void *arg);

int main(void)
{
	pthread_t thread;
	int fd;

	printf("Test of errno's thread-specific value.\n");

	/* This should set errno to ENOENT */
	fd = open("./xyzzy-badfilename", O_RDONLY, 0);

	pthread_create(&thread, NULL, threadfunc, NULL);

	pthread_join(thread, NULL);

	if (fd == -1) {
		if (errno == ENOENT)
			printf("Errno correctly has the value ENOENT\n");
		else
			printf("Errno has an incorrect value: %s (%d)\n",
		    strerror(errno), errno);
	} else {
		printf("Hey! Get rid of xyzzy-badfilename.\n");
	}
	return 0;
}


void*
threadfunc(void *arg)
{
	(void)arg;
	/* This should set errno to EBADF */
	write(-123, "Text", 4);
	return (NULL);
}
