#include <signal.h>
#include <stdio.h>
#include <sys/time.h>

void handler(int);

volatile int signaled;
struct timeval signaltime;

#define TIMEDELAY 200000

int main(void)
{
	struct sigaction si;
	struct itimerval it;
	struct timeval t, tdiff;

	printf("Test of real-time interval timer, one-shot.\n");
	si.sa_handler = handler;
	si.sa_flags = 0;
	sigemptyset(&si.sa_mask);
	sigaction(SIGALRM, &si, NULL);

	getitimer(ITIMER_REAL, &it);
	if ((it.it_value.tv_sec == 0) && (it.it_value.tv_usec == 0)) 
		printf("Old timer value correct.\n");
	else
		printf("Old timer value incorrect.\n");

	it.it_value.tv_sec = 0;
	it.it_value.tv_usec = TIMEDELAY;

	gettimeofday(&t, NULL);
	setitimer(ITIMER_REAL, &it, NULL);

	while (signaled == 0)
		;
	signaled = 0;
	tdiff = signaltime;
	tdiff.tv_usec -= t.tv_usec;
	if (tdiff.tv_usec < 0) {
		tdiff.tv_usec += 1000000;
		tdiff.tv_sec -= 1;
	}
	tdiff.tv_sec -= t.tv_sec;
	
	printf("Signal after %d.%06d\n", tdiff.tv_sec, tdiff.tv_usec);
	sleep(1);
	if (signaled)
		printf("Error: Extra alarm signal recieved.\n");
	return 0;
}

void handler(int sig)
{
	gettimeofday(&signaltime, NULL);
	signaled = 1;
}
