

#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ucontext.h>
#include <sys/types.h>
#include <sys/lwp.h>

void lstart(void *arg);



int main(void)
{

	ucontext_t u;
	ucontext_t *contextp;
	int x, c, z, n;
	int stacksize = 65536;
	void *stackbase;
	lwpid_t l,r;
	int error;
	char buf[100];

	sprintf(buf, "Start\n");
	write(1, buf, strlen(buf));
	sprintf(buf, "Original: LWP %d\n", _lwp_self());

	getcontext(&u);
	contextp = (ucontext_t *)malloc(sizeof(ucontext_t));
	stackbase = malloc(stacksize);
	sigprocmask(SIG_SETMASK, NULL, &contextp->uc_sigmask);
	_lwp_makecontext(contextp, lstart, &x, NULL, 
			 stackbase, stacksize);

	error = _lwp_create(contextp, 0, &l);
	if (error)
	  perror("main");
	sprintf(buf, "System claims new LWP is %d\n", l);
	write(1, buf, strlen(buf));

	sleep(3);
	sprintf(buf, "Exiting.\n");
	write(1, buf, strlen(buf));

	/* Important note: we're not waiting for the other LWP. */
	_lwp_exit();

	sprintf(buf, "ERROR: Shouldn't be here.\n");
	write(1, buf, strlen(buf));

	return 0;
}
		
void lstart(void *arg) 
{

	int y, l;
	char buf[100];

	l = _lwp_self();
	sprintf(buf, "In LWP %d\n", l);
	write(1, buf, strlen(buf));

	sprintf(buf, "LWP %d exiting.\n", l);
	write(1, buf, strlen(buf));

}
