#include <signal.h>
#include <stdlib.h>
#include <sys/ucontext.h>
#include <sys/types.h>
#include <sys/lwp.h>

void lstart(void *arg);

int main(void)
{

	ucontext_t u;
	ucontext_t *contextp;
	int stacksize = 65536;
	void *stackbase;
	int x;
	lwpid_t l,r;
	int error;
	struct sigaction sa;
		
	getcontext(&u);
	contextp = (ucontext_t *)malloc(sizeof(ucontext_t));
	stackbase = malloc(stacksize);
	sigprocmask(SIG_SETMASK, NULL, &contextp->uc_sigmask);
	_lwp_makecontext(contextp, lstart, &x, NULL, 
	    stackbase, stacksize);

	
	error = _lwp_create(contextp, LWP_SUSPENDED, &l);
	if (error)
		perror("_lwp_create");

	sleep(2); /* If LWP isn't suspended, this will let it print first,
		   * which we can detect as an error.
		   */
	printf("Suspended LWP created\n");

	error = _lwp_continue(l);
	if (error)
		perror("_lwp_continue");

	error = _lwp_wait(0, &r);
	if (error) 
		perror("_lwp_wait");

	printf("LWP finished.\n");

}
		
void lstart(void *arg) 
{

	printf("In suspend-started LWP\n");

}
