
/* LWP Test 0: Start a single LWP, pass it an argument.
 * let it print and exit, wait for it. 
 */

#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ucontext.h>
#include <sys/types.h>
#include <sys/lwp.h>

void lstart(void *arg);

int main(void)
{

	ucontext_t *contextp;
	int x, c, z, n;
	int stacksize = 65536;
	void *stackbase;
	lwpid_t l,r;
	int error;
	char buf[100];

	sprintf(buf, "Start\n");
	write(1, buf, strlen(buf));
	sprintf(buf, "Original: LWP %d\n", _lwp_self());
	write(1, buf, strlen(buf));

	x = 100;

	contextp = (ucontext_t *)malloc(sizeof(ucontext_t));
	stackbase = malloc(stacksize);
	sigprocmask(SIG_SETMASK, NULL, &contextp->uc_sigmask);
	_lwp_makecontext(contextp, lstart, &x, NULL, 
	    stackbase, stacksize);

	sprintf(buf, "Creating new LWP...\n");
	write(1, buf, strlen(buf));
	
	error = _lwp_create(contextp, 0, &l);
	if (error)
		perror("main");
	sprintf(buf, "System claims new LWP is %d\n", l);
	write(1, buf, strlen(buf));
	
	/* Something with mutexes would be more clever 
	 *  but isn't what I want to test. 
	 */
	sleep(2); 

	error = _lwp_wait(0, &r);
	if (error) 
		perror("_lwp_wait");
	sprintf(buf, "Waited for lwp %d, got %d\n", 0, r);
	write(1, buf, strlen(buf));

	return 0;
}
		
void lstart(void *arg) 
{

	int y, l;
	char buf[100];

	l = _lwp_self();
	sprintf(buf, "In LWP %d\n", l);
	write(1, buf, strlen(buf));

	y = *(int *)arg;
	sprintf(buf, "LWP %d: arg has value %d.\n", l, y);
	write(1, buf, strlen(buf));

	sprintf(buf, "LWP %d exiting.\n", l);
	write(1, buf, strlen(buf));

}
