

#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ucontext.h>
#include <sys/types.h>
#include <sys/lwp.h>

void lstart(void *arg);



int main(void)
{

	ucontext_t u;
	ucontext_t *contextp;
	int x, c, z, n;
	int stacksize = 65536;
	void *stackbase;
	lwpid_t l,r;
	int error;
	char buf[100];

	z = 40;
	n = 0;
	c = 5;
	sprintf(buf, "Start\n");
	write(1, buf, strlen(buf));
	sprintf(buf, "Original: LWP %d\n", _lwp_self());
	write(1, buf, strlen(buf));
	while (z--) {
		
		x = c;
		
		getcontext(&u);
		contextp = (ucontext_t *)malloc(sizeof(ucontext_t));
		stackbase = malloc(stacksize);
		sigprocmask(SIG_SETMASK, NULL, &contextp->uc_sigmask);
		_lwp_makecontext(contextp, lstart, &x, NULL, 
		    stackbase, stacksize);

	
		error = _lwp_create(contextp, 0, &l);
		if (error)
			perror("main");
		sprintf(buf, "System claims new LWP is %d\n", l);
		write(1, buf, strlen(buf));
		n++;
	}
	
	while (c) {
		sprintf(buf, "Count is %d\n", c);
		write(1, buf, strlen(buf));
		c--;
	}
	while (n) {
		error = _lwp_wait(0, &r);
		if (error) 
			perror("_lwp_wait");
		sprintf(buf, "Waited for lwp %d, got %d\n", 0, r);
		write(1, buf, strlen(buf));
		n--;
	}

	return 0;
}
		
void lstart(void *arg) 
{

	int y, l;
	char buf[100];

	l = _lwp_self();
	sprintf(buf, "In LWP %d\n", l);
	write(1, buf, strlen(buf));

	y = *(int *)arg;
	do {
		sprintf(buf, "LWP %d: arg has value %d.\n", l, y);
		write(1, buf, strlen(buf));
		y--;
	} while (y);
	sprintf(buf, "LWP %d exiting.\n", l);
	write(1, buf, strlen(buf));

}
