
#include <err.h>
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>

void *threadfunc(void *arg);

pthread_mutex_t mutex;

int main(void)
{
	int x,ret;
	pthread_t new;
	void *joinval;

	printf("1: Mutex-test 1\n");

	pthread_mutex_init(&mutex, NULL);
	x = 20;
	pthread_mutex_lock(&mutex);
	ret = pthread_create(&new, NULL, threadfunc, &x);
	if (ret != 0)
		err(1, "pthread_create");

	printf("1: Before releasing the mutex.\n");
	sleep(2);
	pthread_mutex_unlock(&mutex);
	printf("1: After releasing the mutex.\n");
	ret = pthread_join(new, &joinval);
	if (ret != 0)
		err(1, "pthread_join");

	pthread_mutex_lock(&mutex);
	printf("1: Thread joined. X was %d. Return value (int) was %d\n", 
	    x, *(int *)joinval);
	pthread_mutex_unlock(&mutex);
	return 0;
}

void *threadfunc(void *arg)
{
	int *param;

	printf("2: Second thread.\n");

	param = arg;
	printf("2: Locking mutex\n");
	pthread_mutex_lock(&mutex);
	printf("2: Got mutex. *param = %d\n", *param);
	(*param)++;

	pthread_mutex_unlock(&mutex);

	return param;
}
