
#include <signal.h>
#include <stdlib.h>
#include <sys/ucontext.h>
#include <sys/types.h>
#include <sys/lwp.h>
#include <sys/sa.h>

void lstart(void *arg);

int handled;

void handler(int sig, int code, struct sigcontext *scp);
void handler2(int sig, int code, struct sigcontext *scp);
void upcall(int t, struct sa_t *sas[], int e, int i);

int n;

int main(void)
{

	stack_t stack;
	int error;
	char buf[100];
	struct sigaction sa;
	int i, ret;

	sa.sa_handler = (void (*)(int)) handler;
	sigemptyset(&sa.sa_mask);
	sa.sa_flags = 0;
	sigaction(SIGUSR1, &sa, NULL);
	sigaction(SIGSTOP, &sa, NULL);
	sigaction(SIGCONT, &sa, NULL);
	sigaction(SIGTSTP, &sa, NULL);
	sigaction(SIGTTIN, &sa, NULL);
	sigaction(SIGTTOU, &sa, NULL);

	sa.sa_handler = (void (*)(int)) handler2;
	sigaction(SIGINT, &sa, NULL);

	sa_register(upcall, NULL);

	do {
		stack.ss_size = 65536;
		stack.ss_sp = malloc(stack.ss_size);
		ret = sa_stacks(1, &stack);
		printf("Added %d stack%s.\n",
		    ret, (ret == 1) ? "" : "s");
	} while (ret > 0);

	sa_enable();

	printf("Uh, we shouldn't get here.\n");

	return 0;
}

void handler(int sig, int code, struct sigcontext *scp)
{
	printf("Signal handler.\n");
	printf("Signal: %d    Code: %d\n", sig, code);
	printf("Signal being handled in LWP %d\n", _lwp_self());
}


void handler2(int sig, int code, struct sigcontext *scp)
{
	printf("Signal handler.\n");
	printf("Signal: %d    Code: %d\n", sig, code);
	printf("Signal being handled in LWP %d\n", _lwp_self());
	handled = 1;
}

void upcall(int t, struct sa_t *sas[], int e, int i)
{
	int x;

	printf("\nCool, I'm an upcall. ");
	printf("Type: %d\n", t);
	printf("My sa_id: %d\n", sas[0]->sa_id);
	printf("Events: %d\n", e);
	for (x = 1; x < 1 + e ; x++) {
		printf("  %d ID: %d\n", x, sas[x]->sa_id);
	}
	printf("Interrupted: %d\n", i);
	for (x = 1 + e; x < 1 + e + i ; x++) {
		printf("  %d ID: %d\n", x, sas[x]->sa_id);
	}


	if ((++n < 8) && t != 3) {
		printf("Sleeping, should trigger another upcall.\n");
		sleep(5);
	}

}
