
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ucontext.h>
#include <sys/types.h>
#include <sys/lwp.h>
#include <sys/sa.h>

void lstart(void *arg);

int handled;

void handler(int sig, int code, struct sigcontext *scp);
void handler2(int sig, int code, struct sigcontext *scp);
void upcall(int t, struct sa_t *sas[], int e, int i);

void printcontext(ucontext_t *u);

int main(void)
{

	ucontext_t u;
	ucontext_t *contextp;
	int x, c, z, n;
	int stacksize = 65536;
	void *stackbase;
	lwpid_t l,r;
	int error;
	char buf[100];
	struct sigaction sa;

	c = 5;
	z = 2;
	sprintf(buf, "Start\n");
	write(1, buf, strlen(buf));
	sprintf(buf, "Original: LWP %d\n", _lwp_self());
	write(1, buf, strlen(buf));

	sa.sa_handler = (void (*)(int)) handler;
	sigemptyset(&sa.sa_mask);
	sa.sa_flags = 0;
	sigaction(SIGUSR1, &sa, NULL);
	sigaction(SIGSTOP, &sa, NULL);
	sigaction(SIGCONT, &sa, NULL);
	sigaction(SIGTSTP, &sa, NULL);
	sigaction(SIGTTIN, &sa, NULL);
	sigaction(SIGTTOU, &sa, NULL);

	sa.sa_handler = (void (*)(int)) handler2;
	sigaction(SIGINT, &sa, NULL);

	printf("Original stack: ~%p\n", &u);
	printf("Main: %p  lstart: %p\n", main, lstart);

	sa_register(upcall, NULL);
	sa_enable();

	n = 0;
	while (z--) {
		
		x = c;
		
		contextp = (ucontext_t *)malloc(sizeof(ucontext_t));
		stackbase = malloc(stacksize);
		sigprocmask(SIG_SETMASK, NULL, &contextp->uc_sigmask);


		printf("Stack: %p, %08x\n", stackbase, stacksize);
		_lwp_makecontext(contextp, lstart, &x, NULL, 
		    stackbase, stacksize);

		
		error = _lwp_create(contextp, 0, &l);
		if (error)
			perror("main");
		sprintf(buf, "System claims new LWP is %d\n", l);
		write(1, buf, strlen(buf));
		n++;
		
	}
	
	while (n) {
		error = _lwp_wait(0, &r);
		if (error) 
			perror("_lwp_wait");
		sprintf(buf, "Waited for lwp #%d, got #%d (%d left)\n", 
		    0, r, n-1);
		write(1, buf, strlen(buf));
		n--;
	}

	return 0;
}
		
void lstart(void *arg) 
{

	int y, l;
	char buf[100];
	int large;

	l = _lwp_self();
	sprintf(buf, "In LWP %d\n", l);
	write(1, buf, strlen(buf));



	while (1) {
		sprintf(buf, "LWP %d running.\n", l);
		write(1, buf, strlen(buf));
		if (handled) 
			break;
		large = 1000000;
		while(large--);
		sleep(10);
	}
		
	sprintf(buf, "LWP %d exiting.\n", l);
	write(1, buf, strlen(buf));
 	_lwp_exit(); 

}

void handler(int sig, int code, struct sigcontext *scp)
{
	printf("Signal handler.\n");
	printf("Signal: %d    Code: %d\n", sig, code);
	printf("Signal being handled in LWP %d\n", _lwp_self());
}


void handler2(int sig, int code, struct sigcontext *scp)
{
	printf("Signal handler.\n");
	printf("Signal: %d    Code: %d\n", sig, code);
	printf("Signal being handled in LWP %d\n", _lwp_self());
	handled = 1;
}

void upcall(int t, struct sa_t *sas[], int e, int i)
{
	printf("Whoah! How did I get here?\n");
}
