
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ucontext.h>
#include <sys/types.h>
#include <sys/lwp.h>
#include <sys/sa.h>

void lstart(void *arg);

int handled;

void handler(int sig, int code, struct sigcontext *scp);
void handler2(int sig, int code, struct sigcontext *scp);
void upcall(int t, struct sa_t *sas[], int e, int i);

void printcontext(ucontext_t *u);

int main(void)
{

	stack_t stack;
	int error;
	char buf[100];
	int i;

	sa_register(upcall, NULL);

	for (i=0; i<16; i++) {
		stack.ss_size = 65536;
		stack.ss_sp = malloc(stack.ss_size);
		sprintf(buf, "Upcall stack: base: %p  size: %d\n", 
		    stack.ss_sp, stack.ss_size);
		write(1, buf, strlen(buf));
		sa_stacks(1, &stack);
	}
	sa_enable();

	sprintf(buf, "Uh, we shouldn't get here.\n");

	return 0;
}

void upcall(int t, struct sa_t *sas[], int e, int i)
{
	int x;
	char buf1[1000], buf2[100];

	sprintf(buf1, "Cool, I'm an upcall.\n");
	sprintf(buf2, "Type: %d\n" "Events: %d\n" "Interrupted: %d\n", t, e, i);
	strcat(buf1, buf2);
	sprintf(buf2, "My stack: ~%p\n", &x);
	strcat(buf1, buf2);
	sprintf(buf2, "My sa:\n");
	strcat(buf1, buf2);
	sprintf(buf2, "  sa_id: %d\n  sa_cpu: %d\n", sas[0]->sa_id, sas[0]->sa_cpu);
	strcat(buf1, buf2);
	write(1, buf1, strlen(buf1));
}
