
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ucontext.h>
#include <sys/types.h>
#include <sys/lwp.h>
#include <sys/sa.h>

void lstart(void *arg);

int handled;

void handler(int sig, int code, struct sigcontext *scp);
void handler2(int sig, int code, struct sigcontext *scp);
void upcall(int t, struct sa_t *sas[], int e, int i, void *);

int n;

int main(void)
{

	stack_t stack;
	int error;
	char buf[100];
	int i, ret;

	sa_register(upcall, NULL);

	do {
		stack.ss_size = 65536;
		stack.ss_sp = malloc(stack.ss_size);
		ret = sa_stacks(1, &stack);
		printf("Added %d stack%s.\n",
		    ret, (ret == 1) ? "" : "s");
	} while (ret > 0);

	sa_enable();

	printf("Uh, we shouldn't get here.\n");

	return 0;
}

void upcall(int t, struct sa_t *sas[], int e, int i, void *arg)
{
	int x;

	char buf1[1000], buf2[100];

	

	write(1, buf1, strlen(buf1));

	sprintf(buf1, "Cool, I'm an upcall. ");
	sprintf(buf2, "Type: %d\n", t);
	strcat(buf1, buf2);
	sprintf(buf2, "Arg: %p\n", arg);
	strcat(buf1, buf2);
	sprintf(buf2, "My sa_id: %d\n", sas[0]->sa_id);
	strcat(buf1, buf2);
	sprintf(buf2, "  0 context: %p ID: %x CPU: %d\n",
	    sas[0]->sa_context, sas[0]->sa_id, sas[0]->sa_cpu);
	strcat(buf1, buf2);

	sprintf(buf2, "Events: %d\n", e);
	strcat(buf1, buf2);
	for (x = 1; x < 1 + e ; x++) {
		sprintf(buf2, "  %d context: %p ID: %x CPU: %d\n",
		    x, sas[x]->sa_context, sas[x]->sa_id, sas[x]->sa_cpu);
		strcat(buf1, buf2);

	}
	sprintf(buf2, "Interrupted: %d\n", i);
		strcat(buf1, buf2);
	for (x = 1 + e; x < 1 + e + i ; x++) {
		printf("  %d ID: %d\n", x, sas[x]->sa_id);
		strcat(buf1, buf2);
	}


	if ((++n < 8) && t != 3) {
		sprintf(buf2, "Sleeping, should trigger another upcall.\n");
		strcat(buf1, buf2);
		write(1, buf1, strlen(buf1));
		sleep(5);
	}

}

