#include <signal.h>
#include <stdio.h>

void handler(int sig, int code, struct sigcontext *scp);

int main(void)
{
	int ret;
	struct sigaction sa;

	sa.sa_handler = (void (*)(int)) handler;
	sigemptyset(&sa.sa_mask);
	sa.sa_flags = 0;
	sigaction(SIGUSR1, &sa, NULL);
	sigaction(SIGSTOP, &sa, NULL);
	sigaction(SIGCONT, &sa, NULL);
	sigaction(SIGTSTP, &sa, NULL);
	sigaction(SIGTTIN, &sa, NULL);
	sigaction(SIGTTOU, &sa, NULL);

	while (1) {
		ret = sleep(1);
		if (ret != 0)
			printf("Signal recieved.\n");
	}

	return 0;


}

void handler(int sig, int code, struct sigcontext *scp)
{
	printf("Signal handler.\n");
	printf("Signal: %d    Code: %d\n", sig, code);
	abort();
}
