
#include <err.h>
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>

/* Thread test 2.
 * Multiple running threads.
 */

void *threadfunc1(void *arg);
void *threadfunc2(void *arg);

int global;
int glob2;

int main(void)
{
	int x, y, ret;
	pthread_t new1, new2;
	void *joinval;

	printf("A simple pthreads-using program.\n");

	x = 1;
	ret = pthread_create(&new1, NULL, threadfunc1, &x);
	if (ret != 0)
		err(1, "pthread_create(1)");

	y = 10000000;
	ret = pthread_create(&new2, NULL, threadfunc2, &y);
	if (ret != 0)
		err(1, "pthread_create(2)");

	sleep (10);
	printf("Main: telling threads to exit.\n");
	global = 1;

	ret = pthread_join(new1, &joinval);
	if (ret != 0)
		err(1, "pthread_join(1)");

	ret = pthread_join(new2, &joinval);
	if (ret != 0)
		err(1, "pthread_join(2)");

	return 0;
}

void *threadfunc1(void *arg)
{
	int *param;
	param = arg;

	printf("I am the sleeper, sleeping %d seconds, thread %p\n", 
	    *param, pthread_self());

	while (global == 0) {
		printf("Sleep!\n");
		glob2++;
		sleep(*param);
	}
	printf("Sleeper exiting.\n");

	return 0;
}

void *threadfunc2(void *arg)
{
	int *param;
	int x, n;
	param = arg;

	printf("I am the spinner, spinning %d times, thread %p\n", 
	    *param, pthread_self());
	n = 0;
	while (global == 0) {
		printf("Spin! %d\n", glob2);
		x = *param;
		while (x--);
		n++;
	}

	printf("Spinner exiting (%d spins).\n", n);

	return 0;
}
