
#include <err.h>
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>

/* Thread test 2.
 * Multiple running threads, competing for time.
 */

void *threadfunc1(void *arg);
void *threadfunc2(void *arg);

int global;
int spincount = 10000000;

#define NTHREADS 10

int main(void)
{
	int x, y, ret, i;
	pthread_t tid[NTHREADS+1];
	int arg[NTHREADS+1];
	void *joinval;

	printf("A less simple pthreads-using program.\n");

	x = 4;
	ret = pthread_create(&tid[0], NULL, threadfunc1, &x);
	if (ret != 0)
		err(1, "pthread_create(1)");

	for (i = 1; i <= NTHREADS; i++) {
		arg[i] = i + 1;
		ret = pthread_create(&tid[i], NULL, threadfunc2, &arg[i]);
		if (ret != 0)
			err(1, "pthread_create(2)");
	}


	sleep (10);
	printf("Main: telling threads to exit.\n");
	global = 1;

	for (i = 0; i <= NTHREADS; i++) {
		ret = pthread_join(tid[i], NULL);
		if (ret != 0)
			err(1, "pthread_join(2)");
		printf("Joined %d threads (latest %p)\n", i+1, tid[i]);
	}


	return 0;
}

void *threadfunc1(void *arg)
{
	int *param;

	param = arg;

	printf("I am the sleeper, sleeping %d seconds, thread %p\n", 
	    *param, pthread_self());

	while (global == 0) {
		printf("Sleep!\n");
		sleep(*param);
	}
	printf("Sleeper exiting.\n");

	return 0;
}

void *threadfunc2(void *arg)
{
	int param;
	int x;
	param = *(int *)arg;

	printf("I am spinner %d, spinning %d times, thread %p\n", 
	    param, spincount, pthread_self());

	while (global == 0) {
		printf("(%d) Spin!\n", param);
		x = spincount;
		while (x--);
	}

	printf("(%d) Spinner exiting.\n", param);

	return 0;
}
