
#include <err.h>
#include <pthread.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

/* Thread test 4.
 * Multiple running threads, signal handler.
 */

void *threadfunc1(void *arg);
void *threadfunc2(void *arg);

void handler1(int sig, int code, struct sigcontext *scp);
void handler2(int sig, int code, struct sigcontext *scp);

int global;

int main(void)
{
	int x, y, z, ret;
	pthread_t new1, new2, new3;
	void *joinval;
	struct sigaction sa;
	struct itimerval it;

	printf("A simple pthreads-using program with signals.\n");

	x = 2;
	ret = pthread_create(&new1, NULL, threadfunc1, &x);
	if (ret != 0)
		err(1, "pthread_create(1)");

	sa.sa_handler = (void (*)(int)) handler1;
	sigemptyset(&sa.sa_mask);
	sa.sa_flags = 0;
	sigaction(SIGTSTP, &sa, NULL);
	sa.sa_handler = (void (*)(int)) handler2;
	sigaction(SIGALRM, &sa, NULL);

	y = 10000000;
	ret = pthread_create(&new2, NULL, threadfunc2, &y);
	if (ret != 0)
		err(1, "pthread_create(2)");

	z = 10000000;
	ret = pthread_create(&new3, NULL, threadfunc2, &z);
	if (ret != 0)
		err(1, "pthread_create(3)");


	it.it_value.tv_sec = 5;
	it.it_value.tv_usec = 0;
	it.it_interval.tv_sec = 0;
	it.it_interval.tv_usec = 0;
	setitimer(ITIMER_REAL, &it, NULL);

	while (!global) {
		sleep (1);
	}
	printf("Main: telling threads to exit.\n");


	ret = pthread_join(new1, &joinval);
	if (ret != 0)
		err(1, "pthread_join(1)");

	ret = pthread_join(new2, &joinval);
	if (ret != 0)
		err(1, "pthread_join(2)");

	ret = pthread_join(new3, &joinval);
	if (ret != 0)
		err(1, "pthread_join(3)");

	return 0;
}

void *threadfunc1(void *arg)
{
	int *param;

	param = arg;

	printf("I am the sleeper, sleeping %d seconds, thread %p\n", 
	    *param, pthread_self());

	while (global == 0) {
		printf("Sleep!\n");
		sleep(*param);
	}
	printf("Sleeper exiting.\n");

	return 0;
}

void *threadfunc2(void *arg)
{
	int *param;
	int x;
	param = arg;

	printf("I am the spinner, spinning %d times, thread %p\n", 
	    *param, pthread_self());

	while (global == 0) {
		printf("Spin!\n");
		x = *param;
		while (x--);
	}

	printf("Spinner exiting.\n");

	return 0;
}


void handler1(int sig, int code, struct sigcontext *scp)
{
	printf("Signal handler 1.\n");
	printf("Signal: %d    Code: %d\n", sig, code);
	printf("Signal being handled in thread %p\n", pthread_self());
}


void handler2(int sig, int code, struct sigcontext *scp)
{
	printf("Signal handler 2.\n");
	printf("Signal: %d    Code: %d\n", sig, code);
	printf("Signal being handled in thread %p\n", pthread_self());
	global = 1;
}
