#include <err.h>
#include <signal.h>
#include <stdio.h>
#include <sys/time.h>

void handler(int);

volatile int signaled;
struct timeval signaltime;

#define TIMEDELAY 200000
#define REPEATS 11

int main(void)
{
	struct sigaction si;
	struct itimerspec it;
	struct timeval t, tdiff;
	struct sigevent ev;
	timer_t ti;
	int count;
	
	printf("Test of real-time POSIX timer, repeating.\n");
	si.sa_handler = handler;
	si.sa_flags = 0;
	sigemptyset(&si.sa_mask);
	sigaction(SIGUSR1, &si, NULL);

	ev.sigev_notify = SIGEV_SIGNAL;
	ev.sigev_signo = SIGUSR1;

	if (timer_create(CLOCK_REALTIME, &ev, &ti) != 0)
		err(1, "timer_create");
	    
	if (timer_gettime(ti, &it) != 0)
		err(1, "timer_gettime");

	if ((it.it_value.tv_sec == 0) && (it.it_value.tv_nsec == 0)) 
		printf("Old timer value correct.\n");
	else
		printf("Old timer value incorrect.\n");

	it.it_value.tv_sec = 0;
	it.it_value.tv_nsec = TIMEDELAY * 1000L;
	it.it_interval.tv_sec = 0;
	it.it_interval.tv_nsec = TIMEDELAY * 1000L;

	gettimeofday(&t, NULL);
	if (timer_settime(ti, 0, &it, NULL) != 0)
		err(1, "timer_settime");

	count = REPEATS;
	signaled = 0;
	while (count > 0) {
	    while (signaled == 0)
		    ;
	    tdiff = signaltime;
	    tdiff.tv_usec -= t.tv_usec;
	    if (tdiff.tv_usec < 0) {
		    tdiff.tv_usec += 1000000;
		    tdiff.tv_sec -= 1;
	    }
	    tdiff.tv_sec -= t.tv_sec;
	    
	    printf("Signal after %d.%06d\n", tdiff.tv_sec, tdiff.tv_usec);
	    count--;
	    t = signaltime;
	    signaled = 0;
	}
	
	it.it_value.tv_sec = 0;
	it.it_value.tv_nsec = 0;
	if (timer_settime(ti, 0, &it, NULL) != 0)
		err(1, "timer_settime");
	
	sleep(1);
	if (signaled)
		printf("Error: Extra signal recieved.\n");

	if (timer_delete(ti) != 0)
		err(1, "timer_delete");

	return 0;
}

void handler(int sig)
{
	gettimeofday(&signaltime, NULL);
	signaled = 1;
}
