/* 	$NetBSD: gallant12x22.h,v 1.11 2005/12/11 12:24:12 christos Exp $ */

/*
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to the Computer Systems
 * Engineering Group at Lawrence Berkeley Laboratory and to the University
 * of California at Berkeley by Jef Poskanzer.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Derived from: @(#)gallant19.h	8.1 (Berkeley) 6/11/93
 */

static u_char gallant12x22_data[];

static struct wsdisplay_font gallant12x22 = {
	"Gallant",			/* typeface name */
	0,				/* firstchar */
	255 - 0 + 1,			/* numchar */
	WSDISPLAY_FONTENC_ISO,		/* encoding */
	12,				/* width */
	22,				/* height */
	2,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	gallant12x22_data		/* data */
};

static u_char gallant12x22_data[] = {
	/* 0 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 1 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x1f, 0x80, 	/* ...******... */
	0x3f, 0xc0, 	/* ..********.. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x3f, 0xc0, 	/* ..********.. */
	0x1f, 0x80, 	/* ...******... */
	0x0f, 0x00, 	/* ....****.... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 2 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x55, 0x40, 	/* .*.*.*.*.*.. */
	0x2a, 0xa0, 	/* ..*.*.*.*.*. */
	0x55, 0x40, 	/* .*.*.*.*.*.. */
	0x2a, 0xa0, 	/* ..*.*.*.*.*. */
	0x55, 0x40, 	/* .*.*.*.*.*.. */
	0x2a, 0xa0, 	/* ..*.*.*.*.*. */
	0x55, 0x40, 	/* .*.*.*.*.*.. */
	0x2a, 0xa0, 	/* ..*.*.*.*.*. */
	0x55, 0x40, 	/* .*.*.*.*.*.. */
	0x2a, 0xa0, 	/* ..*.*.*.*.*. */
	0x55, 0x40, 	/* .*.*.*.*.*.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 3 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x44, 0x00, 	/* .*...*...... */
	0x44, 0x00, 	/* .*...*...... */
	0x44, 0x00, 	/* .*...*...... */
	0x7c, 0x00, 	/* .*****...... */
	0x44, 0x00, 	/* .*...*...... */
	0x44, 0x00, 	/* .*...*...... */
	0x44, 0x00, 	/* .*...*...... */
	0x03, 0xe0, 	/* ......*****. */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 4 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7c, 0x00, 	/* .*****...... */
	0x40, 0x00, 	/* .*.......... */
	0x40, 0x00, 	/* .*.......... */
	0x78, 0x00, 	/* .****....... */
	0x40, 0x00, 	/* .*.......... */
	0x40, 0x00, 	/* .*.......... */
	0x40, 0x00, 	/* .*.......... */
	0x03, 0xe0, 	/* ......*****. */
	0x02, 0x00, 	/* ......*..... */
	0x02, 0x00, 	/* ......*..... */
	0x03, 0xc0, 	/* ......****.. */
	0x02, 0x00, 	/* ......*..... */
	0x02, 0x00, 	/* ......*..... */
	0x02, 0x00, 	/* ......*..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 5 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x38, 0x00, 	/* ..***....... */
	0x44, 0x00, 	/* .*...*...... */
	0x40, 0x00, 	/* .*.......... */
	0x40, 0x00, 	/* .*.......... */
	0x40, 0x00, 	/* .*.......... */
	0x44, 0x00, 	/* .*...*...... */
	0x38, 0x00, 	/* ..***....... */
	0x03, 0xc0, 	/* ......****.. */
	0x02, 0x20, 	/* ......*...*. */
	0x02, 0x20, 	/* ......*...*. */
	0x03, 0xc0, 	/* ......****.. */
	0x02, 0x80, 	/* ......*.*... */
	0x02, 0x40, 	/* ......*..*.. */
	0x02, 0x20, 	/* ......*...*. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 6 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x40, 0x00, 	/* .*.......... */
	0x40, 0x00, 	/* .*.......... */
	0x40, 0x00, 	/* .*.......... */
	0x40, 0x00, 	/* .*.......... */
	0x40, 0x00, 	/* .*.......... */
	0x40, 0x00, 	/* .*.......... */
	0x7c, 0x00, 	/* .*****...... */
	0x03, 0xe0, 	/* ......*****. */
	0x02, 0x00, 	/* ......*..... */
	0x02, 0x00, 	/* ......*..... */
	0x03, 0xc0, 	/* ......****.. */
	0x02, 0x00, 	/* ......*..... */
	0x02, 0x00, 	/* ......*..... */
	0x02, 0x00, 	/* ......*..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 7 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0e, 0x00, 	/* ....***..... */
	0x17, 0x00, 	/* ...*.***.... */
	0x23, 0x80, 	/* ..*...***... */
	0x61, 0x80, 	/* .**....**... */
	0x61, 0x80, 	/* .**....**... */
	0x71, 0x00, 	/* .***...*.... */
	0x3a, 0x00, 	/* ..***.*..... */
	0x1c, 0x00, 	/* ...***...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 8 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 9 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x44, 0x00, 	/* .*...*...... */
	0x64, 0x00, 	/* .**..*...... */
	0x64, 0x00, 	/* .**..*...... */
	0x54, 0x00, 	/* .*.*.*...... */
	0x4c, 0x00, 	/* .*..**...... */
	0x4c, 0x00, 	/* .*..**...... */
	0x44, 0x00, 	/* .*...*...... */
	0x02, 0x00, 	/* ......*..... */
	0x02, 0x00, 	/* ......*..... */
	0x02, 0x00, 	/* ......*..... */
	0x02, 0x00, 	/* ......*..... */
	0x02, 0x00, 	/* ......*..... */
	0x02, 0x00, 	/* ......*..... */
	0x03, 0xe0, 	/* ......*****. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 10 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x44, 0x00, 	/* .*...*...... */
	0x44, 0x00, 	/* .*...*...... */
	0x44, 0x00, 	/* .*...*...... */
	0x28, 0x00, 	/* ..*.*....... */
	0x28, 0x00, 	/* ..*.*....... */
	0x10, 0x00, 	/* ...*........ */
	0x10, 0x00, 	/* ...*........ */
	0x03, 0xe0, 	/* ......*****. */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 11 */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0xfe, 0x00, 	/* *******..... */
	0xfe, 0x00, 	/* *******..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 12 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xfe, 0x00, 	/* *******..... */
	0xfe, 0x00, 	/* *******..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */

	/* 13 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x07, 0xf0, 	/* .....******* */
	0x07, 0xf0, 	/* .....******* */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */

	/* 14 */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x07, 0xf0, 	/* .....******* */
	0x07, 0xf0, 	/* .....******* */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 15 */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0xff, 0xf0, 	/* ************ */
	0xff, 0xf0, 	/* ************ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */

	/* 16 */
	0x00, 0x00, 	/* ............ */
	0xff, 0xf0, 	/* ************ */
	0xff, 0xf0, 	/* ************ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 17 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0xf0, 	/* ************ */
	0xff, 0xf0, 	/* ************ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 18 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0xf0, 	/* ************ */
	0xff, 0xf0, 	/* ************ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 19 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0xf0, 	/* ************ */
	0xff, 0xf0, 	/* ************ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 20 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0xf0, 	/* ************ */
	0xff, 0xf0, 	/* ************ */
	0x00, 0x00, 	/* ............ */

	/* 21 */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x07, 0xf0, 	/* .....******* */
	0x07, 0xf0, 	/* .....******* */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */

	/* 22 */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0xfe, 0x00, 	/* *******..... */
	0xfe, 0x00, 	/* *******..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */

	/* 23 */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0xff, 0xf0, 	/* ************ */
	0xff, 0xf0, 	/* ************ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 24 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0xf0, 	/* ************ */
	0xff, 0xf0, 	/* ************ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */

	/* 25 */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */

	/* 26 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0xe0, 	/* ........***. */
	0x07, 0x80, 	/* .....****... */
	0x1e, 0x00, 	/* ...****..... */
	0x78, 0x00, 	/* .****....... */
	0x78, 0x00, 	/* .****....... */
	0x1e, 0x00, 	/* ...****..... */
	0x07, 0x80, 	/* .....****... */
	0x00, 0xe0, 	/* ........***. */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 27 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x70, 0x00, 	/* .***........ */
	0x1e, 0x00, 	/* ...****..... */
	0x07, 0x80, 	/* .....****... */
	0x01, 0xe0, 	/* .......****. */
	0x01, 0xe0, 	/* .......****. */
	0x07, 0x80, 	/* .....****... */
	0x1e, 0x00, 	/* ...****..... */
	0x70, 0x00, 	/* .***........ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 28 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x3f, 0xe0, 	/* ..*********. */
	0x7f, 0xc0, 	/* .*********.. */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x31, 0x80, 	/* ..**...**... */
	0x31, 0x80, 	/* ..**...**... */
	0x31, 0xc0, 	/* ..**...***.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 29 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x40, 	/* .........*.. */
	0x00, 0xc0, 	/* ........**.. */
	0x01, 0x80, 	/* .......**... */
	0x7f, 0xc0, 	/* .*********.. */
	0x7f, 0xc0, 	/* .*********.. */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x7f, 0xc0, 	/* .*********.. */
	0x7f, 0xc0, 	/* .*********.. */
	0x30, 0x00, 	/* ..**........ */
	0x60, 0x00, 	/* .**......... */
	0x40, 0x00, 	/* .*.......... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 30 */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x10, 0x00, 	/* ...*........ */
	0x10, 0x00, 	/* ...*........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x3e, 0x00, 	/* ..*****..... */
	0x7c, 0x00, 	/* .*****...... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x3f, 0x20, 	/* ..******..*. */
	0x3f, 0xe0, 	/* ..*********. */
	0x31, 0xc0, 	/* ..**...***.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 31 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 32 ( ) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 33 (!) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 34 (") */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 35 (#) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x03, 0x30, 	/* ......**..** */
	0x03, 0x30, 	/* ......**..** */
	0x03, 0x30, 	/* ......**..** */
	0x06, 0x60, 	/* .....**..**. */
	0x1f, 0xf0, 	/* ...********* */
	0x1f, 0xf0, 	/* ...********* */
	0x0c, 0xc0, 	/* ....**..**.. */
	0x0c, 0xc0, 	/* ....**..**.. */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x7f, 0xc0, 	/* .*********.. */
	0x7f, 0xc0, 	/* .*********.. */
	0x33, 0x00, 	/* ..**..**.... */
	0x66, 0x00, 	/* .**..**..... */
	0x66, 0x00, 	/* .**..**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 36 ($) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x3f, 0xc0, 	/* ..********.. */
	0x66, 0xe0, 	/* .**..**.***. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x00, 	/* .**..**..... */
	0x3e, 0x00, 	/* ..*****..... */
	0x1f, 0x80, 	/* ...******... */
	0x07, 0xc0, 	/* .....*****.. */
	0x06, 0x60, 	/* .....**..**. */
	0x06, 0x60, 	/* .....**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x7f, 0xc0, 	/* .*********.. */
	0x3f, 0x80, 	/* ..*******... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 37 (%) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x38, 0x60, 	/* ..***....**. */
	0x44, 0xc0, 	/* .*...*..**.. */
	0x44, 0xc0, 	/* .*...*..**.. */
	0x45, 0x80, 	/* .*...*.**... */
	0x39, 0x80, 	/* ..***..**... */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x19, 0xc0, 	/* ...**..***.. */
	0x1a, 0x20, 	/* ...**.*...*. */
	0x32, 0x20, 	/* ..**..*...*. */
	0x32, 0x20, 	/* ..**..*...*. */
	0x61, 0xc0, 	/* .**....***.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 38 (&) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x07, 0x00, 	/* .....***.... */
	0x0f, 0x80, 	/* ....*****... */
	0x18, 0xc0, 	/* ...**...**.. */
	0x18, 0xc0, 	/* ...**...**.. */
	0x18, 0xc0, 	/* ...**...**.. */
	0x0f, 0x80, 	/* ....*****... */
	0x1e, 0x00, 	/* ...****..... */
	0x3e, 0x00, 	/* ..*****..... */
	0x77, 0x00, 	/* .***.***.... */
	0x63, 0x60, 	/* .**...**.**. */
	0x61, 0xe0, 	/* .**....****. */
	0x61, 0xc0, 	/* .**....***.. */
	0x61, 0x80, 	/* .**....**... */
	0x3f, 0xe0, 	/* ..*********. */
	0x1e, 0x60, 	/* ...****..**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 39 (') */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x10, 0x00, 	/* ...*........ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 40 (() */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0xc0, 	/* ........**.. */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x80, 	/* ......***... */
	0x03, 0x00, 	/* ......**.... */
	0x07, 0x00, 	/* .....***.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x07, 0x00, 	/* .....***.... */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x80, 	/* ......***... */
	0x01, 0x80, 	/* .......**... */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 41 ()) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x30, 0x00, 	/* ..**........ */
	0x18, 0x00, 	/* ...**....... */
	0x1c, 0x00, 	/* ...***...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0e, 0x00, 	/* ....***..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0e, 0x00, 	/* ....***..... */
	0x0c, 0x00, 	/* ....**...... */
	0x1c, 0x00, 	/* ...***...... */
	0x18, 0x00, 	/* ...**....... */
	0x30, 0x00, 	/* ..**........ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 42 (*) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x06, 0x00, 	/* .....**..... */
	0x66, 0x60, 	/* .**..**..**. */
	0x76, 0xe0, 	/* .***.**.***. */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x19, 0x80, 	/* ...**..**... */
	0x76, 0xe0, 	/* .***.**.***. */
	0x66, 0x60, 	/* .**..**..**. */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 43 (+) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 44 (,) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x10, 0x00, 	/* ...*........ */

	/* 45 (-) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 46 (.) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x0c, 0x00, 	/* ....**...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 47 (/) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x60, 	/* .........**. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x60, 0x00, 	/* .**......... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 48 (0) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x07, 0x00, 	/* .....***.... */
	0x0f, 0x80, 	/* ....*****... */
	0x11, 0x80, 	/* ...*...**... */
	0x10, 0xc0, 	/* ...*....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0x80, 	/* ..**....*... */
	0x18, 0x80, 	/* ...**...*... */
	0x1f, 0x00, 	/* ...*****.... */
	0x0e, 0x00, 	/* ....***..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 49 (1) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x02, 0x00, 	/* ......*..... */
	0x06, 0x00, 	/* .....**..... */
	0x0e, 0x00, 	/* ....***..... */
	0x1e, 0x00, 	/* ...****..... */
	0x36, 0x00, 	/* ..**.**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x3f, 0xc0, 	/* ..********.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 50 (2) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x00, 	/* ...*****.... */
	0x3f, 0x80, 	/* ..*******... */
	0x61, 0xc0, 	/* .**....***.. */
	0x40, 0xc0, 	/* .*......**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x30, 0x20, 	/* ..**......*. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 51 (3) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x1f, 0xc0, 	/* ...*******.. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x40, 0x60, 	/* .*.......**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0xe0, 	/* ........***. */
	0x07, 0xc0, 	/* .....*****.. */
	0x0f, 0xc0, 	/* ....******.. */
	0x00, 0xe0, 	/* ........***. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x40, 0x60, 	/* .*.......**. */
	0x60, 0x40, 	/* .**......*.. */
	0x3f, 0x80, 	/* ..*******... */
	0x1f, 0x00, 	/* ...*****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 52 (4) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x80, 	/* ......***... */
	0x03, 0x80, 	/* ......***... */
	0x05, 0x80, 	/* .....*.**... */
	0x05, 0x80, 	/* .....*.**... */
	0x09, 0x80, 	/* ....*..**... */
	0x09, 0x80, 	/* ....*..**... */
	0x11, 0x80, 	/* ...*...**... */
	0x11, 0x80, 	/* ...*...**... */
	0x21, 0x80, 	/* ..*....**... */
	0x3f, 0xe0, 	/* ..*********. */
	0x7f, 0xe0, 	/* .**********. */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 53 (5) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0xc0, 	/* ....******.. */
	0x0f, 0xc0, 	/* ....******.. */
	0x10, 0x00, 	/* ...*........ */
	0x10, 0x00, 	/* ...*........ */
	0x20, 0x00, 	/* ..*......... */
	0x3f, 0x80, 	/* ..*******... */
	0x31, 0xc0, 	/* ..**...***.. */
	0x00, 0xe0, 	/* ........***. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x40, 0x60, 	/* .*.......**. */
	0x60, 0x60, 	/* .**......**. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 54 (6) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x07, 0x00, 	/* .....***.... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x60, 0x00, 	/* .**......... */
	0x67, 0x80, 	/* .**..****... */
	0x6f, 0xc0, 	/* .**.******.. */
	0x70, 0xe0, 	/* .***....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x40, 	/* .***.....*.. */
	0x3f, 0x80, 	/* ..*******... */
	0x1f, 0x00, 	/* ...*****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 55 (7) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0xe0, 	/* ...********. */
	0x3f, 0xe0, 	/* ..*********. */
	0x60, 0x40, 	/* .**......*.. */
	0x00, 0x40, 	/* .........*.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x80, 	/* ........*... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x00, 	/* .......*.... */
	0x01, 0x00, 	/* .......*.... */
	0x03, 0x00, 	/* ......**.... */
	0x02, 0x00, 	/* ......*..... */
	0x02, 0x00, 	/* ......*..... */
	0x06, 0x00, 	/* .....**..... */
	0x04, 0x00, 	/* .....*...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 56 (8) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x11, 0x80, 	/* ...*...**... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x11, 0x80, 	/* ...*...**... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x18, 0x80, 	/* ...**...*... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 57 (9) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0xe0, 	/* .***....***. */
	0x3f, 0x60, 	/* ..******.**. */
	0x1e, 0x60, 	/* ...****..**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x01, 0x80, 	/* .......**... */
	0x07, 0x00, 	/* .....***.... */
	0x3c, 0x00, 	/* ..****...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 58 (:) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x0c, 0x00, 	/* ....**...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x0c, 0x00, 	/* ....**...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 59 (;) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x0c, 0x00, 	/* ....**...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x10, 0x00, 	/* ...*........ */

	/* 60 (<) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x60, 	/* .........**. */
	0x01, 0xc0, 	/* .......***.. */
	0x07, 0x00, 	/* .....***.... */
	0x1e, 0x00, 	/* ...****..... */
	0x78, 0x00, 	/* .****....... */
	0x78, 0x00, 	/* .****....... */
	0x1e, 0x00, 	/* ...****..... */
	0x07, 0x00, 	/* .....***.... */
	0x01, 0xc0, 	/* .......***.. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 61 (=) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xc0, 	/* .*********.. */
	0x7f, 0xc0, 	/* .*********.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xc0, 	/* .*********.. */
	0x7f, 0xc0, 	/* .*********.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 62 (>) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x60, 0x00, 	/* .**......... */
	0x38, 0x00, 	/* ..***....... */
	0x1e, 0x00, 	/* ...****..... */
	0x07, 0x80, 	/* .....****... */
	0x01, 0xe0, 	/* .......****. */
	0x01, 0xe0, 	/* .......****. */
	0x07, 0x80, 	/* .....****... */
	0x1e, 0x00, 	/* ...****..... */
	0x38, 0x00, 	/* ..***....... */
	0x60, 0x00, 	/* .**......... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 63 (?) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x1f, 0x80, 	/* ...******... */
	0x39, 0xc0, 	/* ..***..***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 64 (@) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x3f, 0xc0, 	/* ..********.. */
	0x30, 0x60, 	/* ..**.....**. */
	0x60, 0x60, 	/* .**......**. */
	0x67, 0x20, 	/* .**..***..*. */
	0x6f, 0xa0, 	/* .**.*****.*. */
	0x6c, 0xa0, 	/* .**.**..*.*. */
	0x6c, 0xa0, 	/* .**.**..*.*. */
	0x67, 0xe0, 	/* .**..******. */
	0x60, 0x00, 	/* .**......... */
	0x30, 0x00, 	/* ..**........ */
	0x3f, 0xe0, 	/* ..*********. */
	0x0f, 0xe0, 	/* ....*******. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 65 (A) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x09, 0x00, 	/* ....*..*.... */
	0x11, 0x80, 	/* ...*...**... */
	0x11, 0x80, 	/* ...*...**... */
	0x10, 0x80, 	/* ...*....*... */
	0x3f, 0xc0, 	/* ..********.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x40, 	/* ..*......*.. */
	0x40, 0x60, 	/* .*.......**. */
	0x40, 0x60, 	/* .*.......**. */
	0xe0, 0xf0, 	/* ***.....**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 66 (B) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0x00, 	/* ********.... */
	0x60, 0x80, 	/* .**.....*... */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x61, 0x80, 	/* .**....**... */
	0x7f, 0x80, 	/* .********... */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0xc0, 	/* .**.....**.. */
	0xff, 0x80, 	/* *********... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 67 (C) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0xc0, 	/* ....******.. */
	0x10, 0x60, 	/* ...*.....**. */
	0x20, 0x20, 	/* ..*.......*. */
	0x20, 0x00, 	/* ..*......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x20, 0x00, 	/* ..*......... */
	0x30, 0x20, 	/* ..**......*. */
	0x18, 0x40, 	/* ...**....*.. */
	0x0f, 0x80, 	/* ....*****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 68 (D) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0x00, 	/* ********.... */
	0x61, 0xc0, 	/* .**....***.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x40, 	/* .**......*.. */
	0x61, 0x80, 	/* .**....**... */
	0xfe, 0x00, 	/* *******..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 69 (E) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xc0, 	/* .*********.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x80, 	/* ..**....*... */
	0x3f, 0x80, 	/* ..*******... */
	0x30, 0x80, 	/* ..**....*... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x20, 	/* ..**......*. */
	0x30, 0x20, 	/* ..**......*. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 70 (F) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xc0, 	/* .*********.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x80, 	/* ..**....*... */
	0x3f, 0x80, 	/* ..*******... */
	0x30, 0x80, 	/* ..**....*... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x78, 0x00, 	/* .****....... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 71 (G) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0xc0, 	/* ....******.. */
	0x10, 0x60, 	/* ...*.....**. */
	0x20, 0x20, 	/* ..*.......*. */
	0x20, 0x00, 	/* ..*......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x61, 0xf0, 	/* .**....***** */
	0x60, 0x60, 	/* .**......**. */
	0x20, 0x60, 	/* ..*......**. */
	0x30, 0x60, 	/* ..**.....**. */
	0x18, 0x60, 	/* ...**....**. */
	0x0f, 0x80, 	/* ....*****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 72 (H) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0xf0, 	/* ****....**** */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x7f, 0xe0, 	/* .**********. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0xf0, 0xf0, 	/* ****....**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 73 (I) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x80, 	/* ...******... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 74 (J) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x80, 	/* ...******... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x04, 0x00, 	/* .....*...... */
	0x38, 0x00, 	/* ..***....... */
	0x30, 0x00, 	/* ..**........ */

	/* 75 (K) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0xe0, 	/* ****....***. */
	0x61, 0x80, 	/* .**....**... */
	0x63, 0x00, 	/* .**...**.... */
	0x66, 0x00, 	/* .**..**..... */
	0x6c, 0x00, 	/* .**.**...... */
	0x78, 0x00, 	/* .****....... */
	0x78, 0x00, 	/* .****....... */
	0x7c, 0x00, 	/* .*****...... */
	0x6e, 0x00, 	/* .**.***..... */
	0x67, 0x00, 	/* .**..***.... */
	0x63, 0x80, 	/* .**...***... */
	0x61, 0xc0, 	/* .**....***.. */
	0x60, 0xe0, 	/* .**.....***. */
	0xf0, 0x70, 	/* ****.....*** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 76 (L) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x78, 0x00, 	/* .****....... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x20, 	/* ..**......*. */
	0x30, 0x20, 	/* ..**......*. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 77 (M) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xe0, 0x70, 	/* ***......*** */
	0x60, 0xe0, 	/* .**.....***. */
	0x70, 0xe0, 	/* .***....***. */
	0x70, 0xe0, 	/* .***....***. */
	0x70, 0xe0, 	/* .***....***. */
	0x59, 0x60, 	/* .*.**..*.**. */
	0x59, 0x60, 	/* .*.**..*.**. */
	0x59, 0x60, 	/* .*.**..*.**. */
	0x4d, 0x60, 	/* .*..**.*.**. */
	0x4e, 0x60, 	/* .*..***..**. */
	0x4e, 0x60, 	/* .*..***..**. */
	0x44, 0x60, 	/* .*...*...**. */
	0x44, 0x60, 	/* .*...*...**. */
	0xe4, 0xf0, 	/* ***..*..**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 78 (N) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xc0, 0x70, 	/* **.......*** */
	0x60, 0x20, 	/* .**.......*. */
	0x70, 0x20, 	/* .***......*. */
	0x78, 0x20, 	/* .****.....*. */
	0x58, 0x20, 	/* .*.**.....*. */
	0x4c, 0x20, 	/* .*..**....*. */
	0x46, 0x20, 	/* .*...**...*. */
	0x47, 0x20, 	/* .*...***..*. */
	0x43, 0x20, 	/* .*....**..*. */
	0x41, 0xa0, 	/* .*.....**.*. */
	0x40, 0xe0, 	/* .*......***. */
	0x40, 0xe0, 	/* .*......***. */
	0x40, 0x60, 	/* .*.......**. */
	0xe0, 0x30, 	/* ***.......** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 79 (O) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x60, 	/* ..*......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x20, 0x40, 	/* ..*......*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 80 (P) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0x80, 	/* .********... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0x60, 	/* ..**.....**. */
	0x30, 0x60, 	/* ..**.....**. */
	0x30, 0x60, 	/* ..**.....**. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x37, 0x80, 	/* ..**.****... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x78, 0x00, 	/* .****....... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 81 (Q) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x60, 	/* ..*......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x38, 0x40, 	/* ..***....*.. */
	0x1f, 0x80, 	/* ...******... */
	0x0e, 0x00, 	/* ....***..... */
	0x1f, 0x00, 	/* ...*****.... */
	0x23, 0x90, 	/* ..*...***..* */
	0x01, 0xe0, 	/* .......****. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 82 (R) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0x00, 	/* ********.... */
	0x61, 0x80, 	/* .**....**... */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0x80, 	/* .**.....*... */
	0x7f, 0x00, 	/* .*******.... */
	0x7c, 0x00, 	/* .*****...... */
	0x6e, 0x00, 	/* .**.***..... */
	0x67, 0x00, 	/* .**..***.... */
	0x63, 0x80, 	/* .**...***... */
	0x61, 0xc0, 	/* .**....***.. */
	0x60, 0xe0, 	/* .**.....***. */
	0xf0, 0x70, 	/* ****.....*** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 83 (S) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0xe0, 	/* ...********. */
	0x30, 0x60, 	/* ..**.....**. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x70, 0x00, 	/* .***........ */
	0x3c, 0x00, 	/* ..****...... */
	0x1e, 0x00, 	/* ...****..... */
	0x07, 0x80, 	/* .....****... */
	0x01, 0xc0, 	/* .......***.. */
	0x00, 0xe0, 	/* ........***. */
	0x40, 0x60, 	/* .*.......**. */
	0x40, 0x60, 	/* .*.......**. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x7f, 0x80, 	/* .********... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 84 (T) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xe0, 	/* .**********. */
	0x46, 0x20, 	/* .*...**...*. */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 85 (U) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x70, 0x40, 	/* .***.....*.. */
	0x3f, 0xc0, 	/* ..********.. */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 86 (V) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xe0, 0xe0, 	/* ***.....***. */
	0x60, 0x40, 	/* .**......*.. */
	0x30, 0x80, 	/* ..**....*... */
	0x30, 0x80, 	/* ..**....*... */
	0x30, 0x80, 	/* ..**....*... */
	0x19, 0x00, 	/* ...**..*.... */
	0x19, 0x00, 	/* ...**..*.... */
	0x19, 0x00, 	/* ...**..*.... */
	0x0c, 0x00, 	/* ....**...... */
	0x0e, 0x00, 	/* ....***..... */
	0x0e, 0x00, 	/* ....***..... */
	0x04, 0x00, 	/* .....*...... */
	0x04, 0x00, 	/* .....*...... */
	0x04, 0x00, 	/* .....*...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 87 (W) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xfe, 0xf0, 	/* *******.**** */
	0x66, 0x20, 	/* .**..**...*. */
	0x66, 0x20, 	/* .**..**...*. */
	0x66, 0x20, 	/* .**..**...*. */
	0x76, 0x20, 	/* .***.**...*. */
	0x77, 0x40, 	/* .***.***.*.. */
	0x33, 0x40, 	/* ..**..**.*.. */
	0x37, 0x40, 	/* ..**.***.*.. */
	0x3b, 0xc0, 	/* ..***.****.. */
	0x3b, 0x80, 	/* ..***.***... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 88 (X) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x11, 0x80, 	/* ...*...**... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x40, 0x60, 	/* .*.......**. */
	0xe0, 0xf0, 	/* ***.....**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 89 (Y) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 90 (Z) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x3f, 0xe0, 	/* ..*********. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x20, 	/* ...**.....*. */
	0x3f, 0xe0, 	/* ..*********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 91 ([) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x07, 0xc0, 	/* .....*****.. */
	0x07, 0xc0, 	/* .....*****.. */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x07, 0xc0, 	/* .....*****.. */
	0x07, 0xc0, 	/* .....*****.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 92 (\) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x06, 0x00, 	/* .....**..... */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 93 (]) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7c, 0x00, 	/* .*****...... */
	0x7c, 0x00, 	/* .*****...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x7c, 0x00, 	/* .*****...... */
	0x7c, 0x00, 	/* .*****...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 94 (^) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x04, 0x00, 	/* .....*...... */
	0x0e, 0x00, 	/* ....***..... */
	0x1b, 0x00, 	/* ...**.**.... */
	0x31, 0x80, 	/* ..**...**... */
	0x60, 0xc0, 	/* .**.....**.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 95 (_) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0xe0, 	/* ***********. */
	0xff, 0xe0, 	/* ***********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 96 (`) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x01, 0x00, 	/* .......*.... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x07, 0x80, 	/* .....****... */
	0x07, 0x80, 	/* .....****... */
	0x03, 0x00, 	/* ......**.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 97 (a) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x18, 0xc0, 	/* ...**...**.. */
	0x10, 0xc0, 	/* ...*....**.. */
	0x03, 0xc0, 	/* ......****.. */
	0x1c, 0xc0, 	/* ...***..**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0xe0, 	/* ...****.***. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 98 (b) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x20, 0x00, 	/* ..*......... */
	0x60, 0x00, 	/* .**......... */
	0xe0, 0x00, 	/* ***......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x67, 0x80, 	/* .**..****... */
	0x6f, 0xc0, 	/* .**.******.. */
	0x70, 0xe0, 	/* .***....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x60, 	/* .***.....**. */
	0x78, 0xc0, 	/* .****...**.. */
	0x4f, 0x80, 	/* .*..*****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 99 (c) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x80, 	/* ...******... */
	0x31, 0xc0, 	/* ..**...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x70, 0x40, 	/* .***.....*.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 100 (d) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x60, 	/* .........**. */
	0x00, 0xe0, 	/* ........***. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x0f, 0x60, 	/* ....****.**. */
	0x31, 0xe0, 	/* ..**...****. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0xe0, 	/* .***....***. */
	0x39, 0x60, 	/* ..***..*.**. */
	0x1e, 0x70, 	/* ...****..*** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 101 (e) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x7f, 0xe0, 	/* .**********. */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x30, 0x00, 	/* ..**........ */
	0x18, 0x60, 	/* ...**....**. */
	0x0f, 0x80, 	/* ....*****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 102 (f) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x03, 0x80, 	/* ......***... */
	0x04, 0xc0, 	/* .....*..**.. */
	0x04, 0xc0, 	/* .....*..**.. */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x1f, 0x80, 	/* ...******... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 103 (g) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x20, 	/* ...*****..*. */
	0x31, 0xe0, 	/* ..**...****. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x31, 0x80, 	/* ..**...**... */
	0x3f, 0x00, 	/* ..******.... */
	0x60, 0x00, 	/* .**......... */
	0x7f, 0xc0, 	/* .*********.. */
	0x3f, 0xe0, 	/* ..*********. */
	0x20, 0x60, 	/* ..*......**. */
	0x40, 0x20, 	/* .*........*. */
	0x40, 0x20, 	/* .*........*. */
	0x7f, 0xc0, 	/* .*********.. */
	0x3f, 0x80, 	/* ..*******... */

	/* 104 (h) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x10, 0x00, 	/* ...*........ */
	0x30, 0x00, 	/* ..**........ */
	0x70, 0x00, 	/* .***........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x37, 0x80, 	/* ..**.****... */
	0x39, 0xc0, 	/* ..***..***.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x79, 0xe0, 	/* .****..****. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 105 (i) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 106 (j) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x03, 0xc0, 	/* ......****.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1f, 0x00, 	/* ...*****.... */
	0x0e, 0x00, 	/* ....***..... */

	/* 107 (k) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x60, 0x00, 	/* .**......... */
	0xe0, 0x00, 	/* ***......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x61, 0xc0, 	/* .**....***.. */
	0x63, 0x00, 	/* .**...**.... */
	0x66, 0x00, 	/* .**..**..... */
	0x7c, 0x00, 	/* .*****...... */
	0x78, 0x00, 	/* .****....... */
	0x7c, 0x00, 	/* .*****...... */
	0x6e, 0x00, 	/* .**.***..... */
	0x67, 0x00, 	/* .**..***.... */
	0x63, 0x80, 	/* .**...***... */
	0xf1, 0xe0, 	/* ****...****. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 108 (l) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 109 (m) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xdd, 0xc0, 	/* **.***.***.. */
	0x6e, 0xe0, 	/* .**.***.***. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0xef, 0x70, 	/* ***.****.*** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 110 (n) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x27, 0x80, 	/* ..*..****... */
	0x79, 0xc0, 	/* .****..***.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x79, 0xe0, 	/* .****..****. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 111 (o) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x40, 	/* .***.....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1f, 0x00, 	/* ...*****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 112 (p) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xef, 0x80, 	/* ***.*****... */
	0x71, 0xc0, 	/* .***...***.. */
	0x60, 0xe0, 	/* .**.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x40, 	/* .**......*.. */
	0x70, 0x80, 	/* .***....*... */
	0x7f, 0x00, 	/* .*******.... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0xf0, 0x00, 	/* ****........ */

	/* 113 (q) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x20, 	/* ....****..*. */
	0x11, 0xe0, 	/* ...*...****. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x60, 	/* .***.....**. */
	0x38, 0xe0, 	/* ..***...***. */
	0x1f, 0xe0, 	/* ...********. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0xf0, 	/* ........**** */

	/* 114 (r) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x73, 0x80, 	/* .***..***... */
	0x34, 0xc0, 	/* ..**.*..**.. */
	0x38, 0xc0, 	/* ..***...**.. */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x78, 0x00, 	/* .****....... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 115 (s) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0xc0, 	/* ...*******.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x38, 0x00, 	/* ..***....... */
	0x1e, 0x00, 	/* ...****..... */
	0x07, 0x80, 	/* .....****... */
	0x01, 0xc0, 	/* .......***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x3f, 0x80, 	/* ..*******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 116 (t) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x04, 0x00, 	/* .....*...... */
	0x04, 0x00, 	/* .....*...... */
	0x0c, 0x00, 	/* ....**...... */
	0x7f, 0xc0, 	/* .*********.. */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x20, 	/* ....**....*. */
	0x0e, 0x40, 	/* ....***..*.. */
	0x07, 0x80, 	/* .....****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 117 (u) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x79, 0xe0, 	/* .****..****. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0x60, 	/* ...****..**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 118 (v) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 119 (w) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0x70, 	/* ********.*** */
	0x66, 0x20, 	/* .**..**...*. */
	0x66, 0x20, 	/* .**..**...*. */
	0x66, 0x20, 	/* .**..**...*. */
	0x37, 0x40, 	/* ..**.***.*.. */
	0x3b, 0x40, 	/* ..***.**.*.. */
	0x3b, 0x40, 	/* ..***.**.*.. */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 120 (x) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf8, 0xf0, 	/* *****...**** */
	0x70, 0x40, 	/* .***.....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1d, 0x00, 	/* ...***.*.... */
	0x0e, 0x00, 	/* ....***..... */
	0x07, 0x00, 	/* .....***.... */
	0x0b, 0x80, 	/* ....*.***... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xe0, 	/* ..*.....***. */
	0xf1, 0xf0, 	/* ****...***** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 121 (y) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0xf0, 	/* ****....**** */
	0x60, 0x20, 	/* .**.......*. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x04, 0x00, 	/* .....*...... */
	0x0c, 0x00, 	/* ....**...... */
	0x08, 0x00, 	/* ....*....... */
	0x78, 0x00, 	/* .****....... */
	0x70, 0x00, 	/* .***........ */

	/* 122 (z) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xe0, 	/* .**********. */
	0x60, 0xe0, 	/* .**.....***. */
	0x41, 0xc0, 	/* .*.....***.. */
	0x03, 0x80, 	/* ......***... */
	0x07, 0x00, 	/* .....***.... */
	0x0e, 0x00, 	/* ....***..... */
	0x1c, 0x00, 	/* ...***...... */
	0x38, 0x20, 	/* ..***.....*. */
	0x70, 0x60, 	/* .***.....**. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 123 ({) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x01, 0xc0, 	/* .......***.. */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x00, 	/* ......**.... */
	0x07, 0x00, 	/* .....***.... */
	0x03, 0x00, 	/* ......**.... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x01, 0xc0, 	/* .......***.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 124 (|) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */

	/* 125 (}) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x38, 0x00, 	/* ..***....... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x0c, 0x00, 	/* ....**...... */
	0x0e, 0x00, 	/* ....***..... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x38, 0x00, 	/* ..***....... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 126 (~) */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1c, 0x20, 	/* ...***....*. */
	0x3e, 0x60, 	/* ..*****..**. */
	0x36, 0xc0, 	/* ..**.**.**.. */
	0x67, 0xc0, 	/* .**..*****.. */
	0x43, 0x80, 	/* .*....***... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 127 */
	0xaa, 0xa0, 	/* *.*.*.*.*.*. */
	0x55, 0x50, 	/* .*.*.*.*.*.* */
	0xaa, 0xa0, 	/* *.*.*.*.*.*. */
	0x55, 0x50, 	/* .*.*.*.*.*.* */
	0xaa, 0xa0, 	/* *.*.*.*.*.*. */
	0x55, 0x50, 	/* .*.*.*.*.*.* */
	0xaa, 0xa0, 	/* *.*.*.*.*.*. */
	0x55, 0x50, 	/* .*.*.*.*.*.* */
	0xaa, 0xa0, 	/* *.*.*.*.*.*. */
	0x55, 0x50, 	/* .*.*.*.*.*.* */
	0xaa, 0xa0, 	/* *.*.*.*.*.*. */
	0x55, 0x50, 	/* .*.*.*.*.*.* */
	0xaa, 0xa0, 	/* *.*.*.*.*.*. */
	0x55, 0x50, 	/* .*.*.*.*.*.* */
	0xaa, 0xa0, 	/* *.*.*.*.*.*. */
	0x55, 0x50, 	/* .*.*.*.*.*.* */
	0xaa, 0xa0, 	/* *.*.*.*.*.*. */
	0x55, 0x50, 	/* .*.*.*.*.*.* */
	0xaa, 0xa0, 	/* *.*.*.*.*.*. */
	0x55, 0x50, 	/* .*.*.*.*.*.* */
	0xaa, 0xa0, 	/* *.*.*.*.*.*. */
	0x55, 0x50, 	/* .*.*.*.*.*.* */

	/* 128 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 129 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 130 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 131 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 132 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 133 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 134 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 135 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 136 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 137 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 138 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 139 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 140 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 141 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 142 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 143 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 144 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 145 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 146 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 147 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 148 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 149 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 150 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 151 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 152 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 153 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 154 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 155 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 156 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 157 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 158 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 159 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 160 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 161 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 162 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x01, 0x00, 	/* .......*.... */
	0x01, 0x00, 	/* .......*.... */
	0x03, 0x00, 	/* ......**.... */
	0x02, 0x00, 	/* ......*..... */
	0x1f, 0x00, 	/* ...*****.... */
	0x37, 0x80, 	/* ..**.****... */
	0x25, 0x80, 	/* ..*..*.**... */
	0x64, 0x00, 	/* .**..*...... */
	0x6c, 0x00, 	/* .**.**...... */
	0x68, 0x00, 	/* .**.*....... */
	0x78, 0x80, 	/* .****...*... */
	0x39, 0x80, 	/* ..***..**... */
	0x1f, 0x00, 	/* ...*****.... */
	0x10, 0x00, 	/* ...*........ */
	0x30, 0x00, 	/* ..**........ */
	0x20, 0x00, 	/* ..*......... */
	0x20, 0x00, 	/* ..*......... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 163 */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x10, 0x00, 	/* ...*........ */
	0x10, 0x00, 	/* ...*........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x3e, 0x00, 	/* ..*****..... */
	0x7c, 0x00, 	/* .*****...... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x3f, 0x20, 	/* ..******..*. */
	0x3f, 0xe0, 	/* ..*********. */
	0x31, 0xc0, 	/* ..**...***.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 164 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x60, 0x20, 	/* .**.......*. */
	0x77, 0x40, 	/* .***.***.*.. */
	0x3b, 0x80, 	/* ..***.***... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1d, 0xc0, 	/* ...***.***.. */
	0x2e, 0xe0, 	/* ..*.***.***. */
	0x40, 0x60, 	/* .*.......**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 165 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x3f, 0xc0, 	/* ..********.. */
	0x06, 0x00, 	/* .....**..... */
	0x3f, 0xc0, 	/* ..********.. */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 166 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */

	/* 167 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0xe0, 	/* ....*******. */
	0x18, 0x60, 	/* ...**....**. */
	0x30, 0x20, 	/* ..**......*. */
	0x38, 0x20, 	/* ..***.....*. */
	0x1e, 0x00, 	/* ...****..... */
	0x1f, 0x80, 	/* ...******... */
	0x31, 0xc0, 	/* ..**...***.. */
	0x60, 0xe0, 	/* .**.....***. */
	0x70, 0x60, 	/* .***.....**. */
	0x38, 0xc0, 	/* ..***...**.. */
	0x1f, 0x80, 	/* ...******... */
	0x07, 0x80, 	/* .....****... */
	0x41, 0xc0, 	/* .*.....***.. */
	0x40, 0xc0, 	/* .*......**.. */
	0x61, 0x80, 	/* .**....**... */
	0x7f, 0x00, 	/* .*******.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 168 */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 169 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x10, 0x80, 	/* ...*....*... */
	0x20, 0x40, 	/* ..*......*.. */
	0x2f, 0x40, 	/* ..*.****.*.. */
	0x59, 0xa0, 	/* .*.**..**.*. */
	0x59, 0xa0, 	/* .*.**..**.*. */
	0x58, 0x20, 	/* .*.**.....*. */
	0x58, 0x20, 	/* .*.**.....*. */
	0x59, 0xa0, 	/* .*.**..**.*. */
	0x59, 0xa0, 	/* .*.**..**.*. */
	0x2f, 0x40, 	/* ..*.****.*.. */
	0x20, 0x40, 	/* ..*......*.. */
	0x10, 0x80, 	/* ...*....*... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 170 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0e, 0x00, 	/* ....***..... */
	0x1f, 0x00, 	/* ...*****.... */
	0x13, 0x80, 	/* ...*..***... */
	0x0f, 0x80, 	/* ....*****... */
	0x19, 0x80, 	/* ...**..**... */
	0x31, 0x80, 	/* ..**...**... */
	0x3f, 0xc0, 	/* ..********.. */
	0x1e, 0xc0, 	/* ...****.**.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x3f, 0xe0, 	/* ..*********. */
	0x7f, 0xc0, 	/* .*********.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 171 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x02, 0x20, 	/* ......*...*. */
	0x04, 0x40, 	/* .....*...*.. */
	0x08, 0x80, 	/* ....*...*... */
	0x11, 0x00, 	/* ...*...*.... */
	0x33, 0x00, 	/* ..**..**.... */
	0x19, 0x80, 	/* ...**..**... */
	0x0c, 0xc0, 	/* ....**..**.. */
	0x06, 0x60, 	/* .....**..**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 172 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 173 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x80, 	/* ...******... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 174 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x10, 0x80, 	/* ...*....*... */
	0x20, 0x40, 	/* ..*......*.. */
	0x3f, 0x40, 	/* ..******.*.. */
	0x59, 0xa0, 	/* .*.**..**.*. */
	0x59, 0xa0, 	/* .*.**..**.*. */
	0x5f, 0xa0, 	/* .*.******.*. */
	0x5b, 0x20, 	/* .*.**.**..*. */
	0x5b, 0x20, 	/* .*.**.**..*. */
	0x59, 0xa0, 	/* .*.**..**.*. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x20, 0x40, 	/* ..*......*.. */
	0x10, 0x80, 	/* ...*....*... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 175 */
	0x3f, 0xc0, 	/* ..********.. */
	0x3f, 0xc0, 	/* ..********.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 176 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0e, 0x00, 	/* ....***..... */
	0x17, 0x00, 	/* ...*.***.... */
	0x23, 0x80, 	/* ..*...***... */
	0x61, 0x80, 	/* .**....**... */
	0x61, 0x80, 	/* .**....**... */
	0x71, 0x00, 	/* .***...*.... */
	0x3a, 0x00, 	/* ..***.*..... */
	0x1c, 0x00, 	/* ...***...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 177 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 178 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0e, 0x00, 	/* ....***..... */
	0x1f, 0x00, 	/* ...*****.... */
	0x13, 0x00, 	/* ...*..**.... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x1f, 0x00, 	/* ...*****.... */
	0x1f, 0x00, 	/* ...*****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 179 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0e, 0x00, 	/* ....***..... */
	0x1f, 0x00, 	/* ...*****.... */
	0x13, 0x00, 	/* ...*..**.... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x03, 0x00, 	/* ......**.... */
	0x13, 0x00, 	/* ...*..**.... */
	0x1f, 0x00, 	/* ...*****.... */
	0x0e, 0x00, 	/* ....***..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 180 */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x1c, 0x00, 	/* ...***...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 181 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x79, 0xe0, 	/* .****..****. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x3e, 0x60, 	/* ..*****..**. */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x60, 0x00, 	/* .**......... */

	/* 182 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0xc0, 	/* ...*******.. */
	0x3e, 0xc0, 	/* ..*****.**.. */
	0x7e, 0xc0, 	/* .******.**.. */
	0x7e, 0xc0, 	/* .******.**.. */
	0x7e, 0xc0, 	/* .******.**.. */
	0x3e, 0xc0, 	/* ..*****.**.. */
	0x1e, 0xc0, 	/* ...****.**.. */
	0x06, 0xc0, 	/* .....**.**.. */
	0x06, 0xc0, 	/* .....**.**.. */
	0x06, 0xc0, 	/* .....**.**.. */
	0x06, 0xc0, 	/* .....**.**.. */
	0x06, 0xc0, 	/* .....**.**.. */
	0x06, 0xc0, 	/* .....**.**.. */
	0x06, 0xc0, 	/* .....**.**.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 183 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x0f, 0x00, 	/* ....****.... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 184 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x02, 0x00, 	/* ......*..... */
	0x03, 0x00, 	/* ......**.... */
	0x01, 0x80, 	/* .......**... */
	0x09, 0x80, 	/* ....*..**... */
	0x07, 0x00, 	/* .....***.... */

	/* 185 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x0e, 0x00, 	/* ....***..... */
	0x0e, 0x00, 	/* ....***..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 186 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x07, 0x00, 	/* .....***.... */
	0x0b, 0x80, 	/* ....*.***... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1d, 0x00, 	/* ...***.*.... */
	0x0e, 0x00, 	/* ....***..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x3f, 0xe0, 	/* ..*********. */
	0x7f, 0xc0, 	/* .*********.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 187 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x66, 0x00, 	/* .**..**..... */
	0x33, 0x00, 	/* ..**..**.... */
	0x19, 0x80, 	/* ...**..**... */
	0x0c, 0xc0, 	/* ....**..**.. */
	0x08, 0x80, 	/* ....*...*... */
	0x11, 0x00, 	/* ...*...*.... */
	0x22, 0x00, 	/* ..*...*..... */
	0x44, 0x00, 	/* .*...*...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 188 */
	0x00, 0x00, 	/* ............ */
	0x18, 0x00, 	/* ...**....... */
	0x38, 0x00, 	/* ..***....... */
	0x38, 0x00, 	/* ..***....... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x20, 	/* ...**.....*. */
	0x18, 0x60, 	/* ...**....**. */
	0x18, 0xc0, 	/* ...**...**.. */
	0x19, 0x80, 	/* ...**..**... */
	0x3f, 0x40, 	/* ..******.*.. */
	0x06, 0xc0, 	/* .....**.**.. */
	0x0d, 0xc0, 	/* ....**.***.. */
	0x19, 0xc0, 	/* ...**..***.. */
	0x32, 0xc0, 	/* ..**..*.**.. */
	0x64, 0xc0, 	/* .**..*..**.. */
	0x47, 0xe0, 	/* .*...******. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 189 */
	0x00, 0x00, 	/* ............ */
	0x18, 0x00, 	/* ...**....... */
	0x38, 0x00, 	/* ..***....... */
	0x38, 0x00, 	/* ..***....... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x20, 	/* ...**.....*. */
	0x18, 0x60, 	/* ...**....**. */
	0x18, 0xc0, 	/* ...**...**.. */
	0x19, 0x80, 	/* ...**..**... */
	0x3f, 0xc0, 	/* ..********.. */
	0x07, 0xe0, 	/* .....******. */
	0x0f, 0x60, 	/* ....****.**. */
	0x1a, 0x60, 	/* ...**.*..**. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x61, 0x80, 	/* .**....**... */
	0x43, 0x00, 	/* .*....**.... */
	0x03, 0xe0, 	/* ......*****. */
	0x03, 0xe0, 	/* ......*****. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 190 */
	0x00, 0x00, 	/* ............ */
	0x38, 0x00, 	/* ..***....... */
	0x7c, 0x00, 	/* .*****...... */
	0x4c, 0x00, 	/* .*..**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x20, 	/* ...**.....*. */
	0x0c, 0x60, 	/* ....**...**. */
	0x4c, 0xc0, 	/* .*..**..**.. */
	0x7d, 0x80, 	/* .*****.**... */
	0x3b, 0x40, 	/* ..***.**.*.. */
	0x06, 0xc0, 	/* .....**.**.. */
	0x0d, 0xc0, 	/* ....**.***.. */
	0x19, 0xc0, 	/* ...**..***.. */
	0x32, 0xc0, 	/* ..**..*.**.. */
	0x64, 0xc0, 	/* .**..*..**.. */
	0x47, 0xe0, 	/* .*...******. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 191 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x40, 	/* ..**.....*.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1f, 0x80, 	/* ...******... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 192 */
	0x1c, 0x00, 	/* ...***...... */
	0x0f, 0x00, 	/* ....****.... */
	0x03, 0x80, 	/* ......***... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x09, 0x00, 	/* ....*..*.... */
	0x11, 0x80, 	/* ...*...**... */
	0x11, 0x80, 	/* ...*...**... */
	0x10, 0x80, 	/* ...*....*... */
	0x3f, 0xc0, 	/* ..********.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x40, 	/* ..*......*.. */
	0x40, 0x60, 	/* .*.......**. */
	0x40, 0x60, 	/* .*.......**. */
	0xe0, 0xf0, 	/* ***.....**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 193 */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x1c, 0x00, 	/* ...***...... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x09, 0x00, 	/* ....*..*.... */
	0x11, 0x80, 	/* ...*...**... */
	0x11, 0x80, 	/* ...*...**... */
	0x10, 0x80, 	/* ...*....*... */
	0x3f, 0xc0, 	/* ..********.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x40, 	/* ..*......*.. */
	0x40, 0x60, 	/* .*.......**. */
	0x40, 0x60, 	/* .*.......**. */
	0xe0, 0xf0, 	/* ***.....**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 194 */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x09, 0x00, 	/* ....*..*.... */
	0x11, 0x80, 	/* ...*...**... */
	0x11, 0x80, 	/* ...*...**... */
	0x10, 0x80, 	/* ...*....*... */
	0x3f, 0xc0, 	/* ..********.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x40, 	/* ..*......*.. */
	0x40, 0x60, 	/* .*.......**. */
	0x40, 0x60, 	/* .*.......**. */
	0xe0, 0xf0, 	/* ***.....**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 195 */
	0x0c, 0xc0, 	/* ....**..**.. */
	0x1f, 0x80, 	/* ...******... */
	0x33, 0x00, 	/* ..**..**.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x09, 0x00, 	/* ....*..*.... */
	0x11, 0x80, 	/* ...*...**... */
	0x11, 0x80, 	/* ...*...**... */
	0x10, 0x80, 	/* ...*....*... */
	0x3f, 0xc0, 	/* ..********.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x40, 	/* ..*......*.. */
	0x40, 0x60, 	/* .*.......**. */
	0x40, 0x60, 	/* .*.......**. */
	0xe0, 0xf0, 	/* ***.....**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 196 */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x09, 0x00, 	/* ....*..*.... */
	0x11, 0x80, 	/* ...*...**... */
	0x11, 0x80, 	/* ...*...**... */
	0x10, 0x80, 	/* ...*....*... */
	0x3f, 0xc0, 	/* ..********.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x40, 	/* ..*......*.. */
	0x40, 0x60, 	/* .*.......**. */
	0x40, 0x60, 	/* .*.......**. */
	0xe0, 0xf0, 	/* ***.....**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 197 */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0x0f, 0x00, 	/* ....****.... */
	0x06, 0x00, 	/* .....**..... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x09, 0x00, 	/* ....*..*.... */
	0x11, 0x80, 	/* ...*...**... */
	0x11, 0x80, 	/* ...*...**... */
	0x10, 0x80, 	/* ...*....*... */
	0x3f, 0xc0, 	/* ..********.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x40, 	/* ..*......*.. */
	0x40, 0x60, 	/* .*.......**. */
	0x40, 0x60, 	/* .*.......**. */
	0xe0, 0xf0, 	/* ***.....**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 198 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0xe0, 	/* ....*******. */
	0x0e, 0x20, 	/* ....***...*. */
	0x16, 0x20, 	/* ...*.**...*. */
	0x16, 0x00, 	/* ...*.**..... */
	0x16, 0x00, 	/* ...*.**..... */
	0x16, 0x40, 	/* ...*.**..*.. */
	0x27, 0xc0, 	/* ..*..*****.. */
	0x26, 0x40, 	/* ..*..**..*.. */
	0x3e, 0x00, 	/* ..*****..... */
	0x26, 0x00, 	/* ..*..**..... */
	0x46, 0x00, 	/* .*...**..... */
	0x46, 0x10, 	/* .*...**....* */
	0x46, 0x10, 	/* .*...**....* */
	0xe7, 0xf0, 	/* ***..******* */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 199 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0xc0, 	/* ....******.. */
	0x10, 0x60, 	/* ...*.....**. */
	0x20, 0x20, 	/* ..*.......*. */
	0x20, 0x00, 	/* ..*......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x20, 0x00, 	/* ..*......... */
	0x30, 0x20, 	/* ..**......*. */
	0x18, 0x40, 	/* ...**....*.. */
	0x0f, 0x80, 	/* ....*****... */
	0x02, 0x00, 	/* ......*..... */
	0x03, 0x00, 	/* ......**.... */
	0x01, 0x80, 	/* .......**... */
	0x09, 0x80, 	/* ....*..**... */
	0x07, 0x00, 	/* .....***.... */

	/* 200 */
	0x1c, 0x00, 	/* ...***...... */
	0x0f, 0x00, 	/* ....****.... */
	0x03, 0x80, 	/* ......***... */
	0x7f, 0xc0, 	/* .*********.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x80, 	/* ..**....*... */
	0x3f, 0x80, 	/* ..*******... */
	0x30, 0x80, 	/* ..**....*... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x20, 	/* ..**......*. */
	0x30, 0x20, 	/* ..**......*. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 201 */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x1c, 0x00, 	/* ...***...... */
	0x7f, 0xc0, 	/* .*********.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x80, 	/* ..**....*... */
	0x3f, 0x80, 	/* ..*******... */
	0x30, 0x80, 	/* ..**....*... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x20, 	/* ..**......*. */
	0x30, 0x20, 	/* ..**......*. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 202 */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0x7f, 0xc0, 	/* .*********.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x80, 	/* ..**....*... */
	0x3f, 0x80, 	/* ..*******... */
	0x30, 0x80, 	/* ..**....*... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x20, 	/* ..**......*. */
	0x30, 0x20, 	/* ..**......*. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 203 */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xc0, 	/* .*********.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x80, 	/* ..**....*... */
	0x3f, 0x80, 	/* ..*******... */
	0x30, 0x80, 	/* ..**....*... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x20, 	/* ..**......*. */
	0x30, 0x20, 	/* ..**......*. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 204 */
	0x1c, 0x00, 	/* ...***...... */
	0x0f, 0x00, 	/* ....****.... */
	0x03, 0x80, 	/* ......***... */
	0x1f, 0x80, 	/* ...******... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 205 */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x1c, 0x00, 	/* ...***...... */
	0x1f, 0x80, 	/* ...******... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 206 */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0x1f, 0x80, 	/* ...******... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 207 */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x80, 	/* ...******... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 208 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0x00, 	/* ********.... */
	0x61, 0xc0, 	/* .**....***.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0xf8, 0x60, 	/* *****....**. */
	0xf8, 0x60, 	/* *****....**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x40, 	/* .**......*.. */
	0x61, 0x80, 	/* .**....**... */
	0xfe, 0x00, 	/* *******..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 209 */
	0x0c, 0xc0, 	/* ....**..**.. */
	0x1f, 0x80, 	/* ...******... */
	0x33, 0x00, 	/* ..**..**.... */
	0xc0, 0x70, 	/* **.......*** */
	0x60, 0x20, 	/* .**.......*. */
	0x70, 0x20, 	/* .***......*. */
	0x78, 0x20, 	/* .****.....*. */
	0x58, 0x20, 	/* .*.**.....*. */
	0x4c, 0x20, 	/* .*..**....*. */
	0x46, 0x20, 	/* .*...**...*. */
	0x47, 0x20, 	/* .*...***..*. */
	0x43, 0x20, 	/* .*....**..*. */
	0x41, 0xa0, 	/* .*.....**.*. */
	0x40, 0xe0, 	/* .*......***. */
	0x40, 0xe0, 	/* .*......***. */
	0x40, 0x60, 	/* .*.......**. */
	0xe0, 0x30, 	/* ***.......** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 210 */
	0x1c, 0x00, 	/* ...***...... */
	0x0f, 0x00, 	/* ....****.... */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x60, 	/* ..*......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x20, 0x40, 	/* ..*......*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 211 */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x1c, 0x00, 	/* ...***...... */
	0x0f, 0x00, 	/* ....****.... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x60, 	/* ..*......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x20, 0x40, 	/* ..*......*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 212 */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0x0f, 0x00, 	/* ....****.... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x60, 	/* ..*......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x20, 0x40, 	/* ..*......*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 213 */
	0x0c, 0xc0, 	/* ....**..**.. */
	0x1f, 0x80, 	/* ...******... */
	0x33, 0x00, 	/* ..**..**.... */
	0x0f, 0x00, 	/* ....****.... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x60, 	/* ..*......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x20, 0x40, 	/* ..*......*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 214 */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x60, 	/* ..*......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x20, 0x40, 	/* ..*......*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 215 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x60, 0x60, 	/* .**......**. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x19, 0x80, 	/* ...**..**... */
	0x0f, 0x00, 	/* ....****.... */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x60, 0x60, 	/* .**......**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 216 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x60, 	/* .........**. */
	0x0f, 0xc0, 	/* ....******.. */
	0x11, 0xc0, 	/* ...*...***.. */
	0x21, 0xc0, 	/* ..*....***.. */
	0x21, 0xe0, 	/* ..*....****. */
	0x63, 0x60, 	/* .**...**.**. */
	0x63, 0x60, 	/* .**...**.**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x6c, 0x60, 	/* .**.**...**. */
	0x6c, 0x60, 	/* .**.**...**. */
	0x78, 0x60, 	/* .****....**. */
	0x38, 0x40, 	/* ..***....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x6f, 0x00, 	/* .**.****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 217 */
	0x1c, 0x00, 	/* ...***...... */
	0x0f, 0x00, 	/* ....****.... */
	0x03, 0x80, 	/* ......***... */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x70, 0x40, 	/* .***.....*.. */
	0x3f, 0xc0, 	/* ..********.. */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 218 */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x1c, 0x00, 	/* ...***...... */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x70, 0x40, 	/* .***.....*.. */
	0x3f, 0xc0, 	/* ..********.. */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 219 */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x70, 0x40, 	/* .***.....*.. */
	0x3f, 0xc0, 	/* ..********.. */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 220 */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x70, 0x40, 	/* .***.....*.. */
	0x3f, 0xc0, 	/* ..********.. */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 221 */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x1c, 0x00, 	/* ...***...... */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 222 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x78, 0x00, 	/* .****....... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x3f, 0x80, 	/* ..*******... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0x60, 	/* ..**.....**. */
	0x30, 0x60, 	/* ..**.....**. */
	0x30, 0x60, 	/* ..**.....**. */
	0x30, 0x60, 	/* ..**.....**. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x3f, 0x80, 	/* ..*******... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x78, 0x00, 	/* .****....... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 223 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x31, 0x80, 	/* ..**...**... */
	0x31, 0x80, 	/* ..**...**... */
	0x33, 0x80, 	/* ..**..***... */
	0x36, 0x00, 	/* ..**.**..... */
	0x36, 0x00, 	/* ..**.**..... */
	0x36, 0x00, 	/* ..**.**..... */
	0x33, 0x80, 	/* ..**..***... */
	0x31, 0xc0, 	/* ..**...***.. */
	0x30, 0xe0, 	/* ..**....***. */
	0x34, 0x60, 	/* ..**.*...**. */
	0x36, 0x60, 	/* ..**.**..**. */
	0x77, 0xc0, 	/* .***.*****.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 224 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1c, 0x00, 	/* ...***...... */
	0x0f, 0x00, 	/* ....****.... */
	0x03, 0x80, 	/* ......***... */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x18, 0xc0, 	/* ...**...**.. */
	0x10, 0xc0, 	/* ...*....**.. */
	0x03, 0xc0, 	/* ......****.. */
	0x1c, 0xc0, 	/* ...***..**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0xe0, 	/* ...****.***. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 225 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x1c, 0x00, 	/* ...***...... */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x18, 0xc0, 	/* ...**...**.. */
	0x10, 0xc0, 	/* ...*....**.. */
	0x03, 0xc0, 	/* ......****.. */
	0x1c, 0xc0, 	/* ...***..**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0xe0, 	/* ...****.***. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 226 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x18, 0xc0, 	/* ...**...**.. */
	0x10, 0xc0, 	/* ...*....**.. */
	0x03, 0xc0, 	/* ......****.. */
	0x1c, 0xc0, 	/* ...***..**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0xe0, 	/* ...****.***. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 227 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0xc0, 	/* ....**..**.. */
	0x1f, 0x80, 	/* ...******... */
	0x33, 0x00, 	/* ..**..**.... */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x18, 0xc0, 	/* ...**...**.. */
	0x10, 0xc0, 	/* ...*....**.. */
	0x03, 0xc0, 	/* ......****.. */
	0x1c, 0xc0, 	/* ...***..**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0xe0, 	/* ...****.***. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 228 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x18, 0xc0, 	/* ...**...**.. */
	0x10, 0xc0, 	/* ...*....**.. */
	0x03, 0xc0, 	/* ......****.. */
	0x1c, 0xc0, 	/* ...***..**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0xe0, 	/* ...****.***. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 229 */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0x0f, 0x00, 	/* ....****.... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x18, 0xc0, 	/* ...**...**.. */
	0x10, 0xc0, 	/* ...*....**.. */
	0x03, 0xc0, 	/* ......****.. */
	0x1c, 0xc0, 	/* ...***..**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0xe0, 	/* ...****.***. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 230 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x80, 	/* ...******... */
	0x36, 0x40, 	/* ..**.**..*.. */
	0x26, 0x60, 	/* ..*..**..**. */
	0x0e, 0x60, 	/* ....***..**. */
	0x3f, 0xe0, 	/* ..*********. */
	0x66, 0x00, 	/* .**..**..... */
	0x66, 0x00, 	/* .**..**..... */
	0x66, 0x00, 	/* .**..**..... */
	0x67, 0x60, 	/* .**..***.**. */
	0x3f, 0xc0, 	/* ..********.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 231 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x80, 	/* ...******... */
	0x31, 0xc0, 	/* ..**...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x70, 0x40, 	/* .***.....*.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x1f, 0x80, 	/* ...******... */
	0x02, 0x00, 	/* ......*..... */
	0x03, 0x00, 	/* ......**.... */
	0x01, 0x80, 	/* .......**... */
	0x09, 0x80, 	/* ....*..**... */
	0x07, 0x00, 	/* .....***.... */

	/* 232 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1c, 0x00, 	/* ...***...... */
	0x0f, 0x00, 	/* ....****.... */
	0x03, 0x80, 	/* ......***... */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x7f, 0xe0, 	/* .**********. */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x30, 0x00, 	/* ..**........ */
	0x18, 0x60, 	/* ...**....**. */
	0x0f, 0x80, 	/* ....*****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 233 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x1c, 0x00, 	/* ...***...... */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x7f, 0xe0, 	/* .**********. */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x30, 0x00, 	/* ..**........ */
	0x18, 0x60, 	/* ...**....**. */
	0x0f, 0x80, 	/* ....*****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 234 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x7f, 0xe0, 	/* .**********. */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x30, 0x00, 	/* ..**........ */
	0x18, 0x60, 	/* ...**....**. */
	0x0f, 0x80, 	/* ....*****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 235 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x7f, 0xe0, 	/* .**********. */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x30, 0x00, 	/* ..**........ */
	0x18, 0x60, 	/* ...**....**. */
	0x0f, 0x80, 	/* ....*****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 236 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1c, 0x00, 	/* ...***...... */
	0x0f, 0x00, 	/* ....****.... */
	0x03, 0x80, 	/* ......***... */
	0x00, 0x00, 	/* ............ */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 237 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x1c, 0x00, 	/* ...***...... */
	0x00, 0x00, 	/* ............ */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 238 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 239 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 240 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x30, 0xc0, 	/* ..**....**.. */
	0x1f, 0x80, 	/* ...******... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x00, 	/* ...*****.... */
	0x31, 0x80, 	/* ..**...**... */
	0x01, 0xc0, 	/* .......***.. */
	0x0f, 0xc0, 	/* ....******.. */
	0x10, 0xe0, 	/* ...*....***. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x40, 	/* .***.....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1f, 0x00, 	/* ...*****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 241 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0xc0, 	/* ....**..**.. */
	0x1f, 0x80, 	/* ...******... */
	0x33, 0x00, 	/* ..**..**.... */
	0x00, 0x00, 	/* ............ */
	0x27, 0x80, 	/* ..*..****... */
	0x79, 0xc0, 	/* .****..***.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x79, 0xe0, 	/* .****..****. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 242 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1c, 0x00, 	/* ...***...... */
	0x0f, 0x00, 	/* ....****.... */
	0x03, 0x80, 	/* ......***... */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x40, 	/* .***.....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1f, 0x00, 	/* ...*****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 243 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x1c, 0x00, 	/* ...***...... */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x40, 	/* .***.....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1f, 0x00, 	/* ...*****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 244 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x40, 	/* .***.....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1f, 0x00, 	/* ...*****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 245 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0xc0, 	/* ....**..**.. */
	0x1f, 0x80, 	/* ...******... */
	0x33, 0x00, 	/* ..**..**.... */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x40, 	/* .***.....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1f, 0x00, 	/* ...*****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 246 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x40, 	/* .***.....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1f, 0x00, 	/* ...*****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 247 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 248 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0xe0, 	/* ....*******. */
	0x11, 0xc0, 	/* ...*...***.. */
	0x21, 0xe0, 	/* ..*....****. */
	0x63, 0x60, 	/* .**...**.**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x6c, 0x60, 	/* .**.**...**. */
	0x78, 0x40, 	/* .****....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x7f, 0x00, 	/* .*******.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 249 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1c, 0x00, 	/* ...***...... */
	0x0f, 0x00, 	/* ....****.... */
	0x03, 0x80, 	/* ......***... */
	0x00, 0x00, 	/* ............ */
	0x79, 0xe0, 	/* .****..****. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0x60, 	/* ...****..**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 250 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x1c, 0x00, 	/* ...***...... */
	0x00, 0x00, 	/* ............ */
	0x79, 0xe0, 	/* .****..****. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0x60, 	/* ...****..**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 251 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x79, 0xe0, 	/* .****..****. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0x60, 	/* ...****..**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 252 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x79, 0xe0, 	/* .****..****. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0x60, 	/* ...****..**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 253 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x03, 0x80, 	/* ......***... */
	0x0f, 0x00, 	/* ....****.... */
	0x1c, 0x00, 	/* ...***...... */
	0x00, 0x00, 	/* ............ */
	0xf0, 0xf0, 	/* ****....**** */
	0x60, 0x20, 	/* .**.......*. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x04, 0x00, 	/* .....*...... */
	0x0c, 0x00, 	/* ....**...... */
	0x08, 0x00, 	/* ....*....... */
	0x78, 0x00, 	/* .****....... */
	0x70, 0x00, 	/* .***........ */

	/* 254 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xe0, 0x00, 	/* ***......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x6f, 0x80, 	/* .**.*****... */
	0x71, 0xc0, 	/* .***...***.. */
	0x60, 0xe0, 	/* .**.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x40, 	/* .**......*.. */
	0x70, 0x80, 	/* .***....*... */
	0x7f, 0x00, 	/* .*******.... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0xf0, 0x00, 	/* ****........ */

	/* 255 */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0xf0, 	/* ****....**** */
	0x60, 0x20, 	/* .**.......*. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x04, 0x00, 	/* .....*...... */
	0x0c, 0x00, 	/* ....**...... */
	0x08, 0x00, 	/* ....*....... */
	0x78, 0x00, 	/* .****....... */
	0x70, 0x00, 	/* .***........ */
};
