atf_test_case noflags
noflags_head() {
    atf_set "descr" "Checks that ls produces the correct output when not" \
                    "using any option"
}
noflags_body() {
    if [ -z "$FSU_DIR" -o -z "$FSU_IMG" ]; then
	atf_fail "variables: \$FSU_DIR and \$FSU_IMG should be set";
    fi
    ${FSU_DIR}/src/fsu_mkdir/fsu_mkdir ${FSU_IMG} dir
    ${FSU_DIR}/src/fsu_touch/fsu_touch ${FSU_IMG} dir/a
    ${FSU_DIR}/src/fsu_touch/fsu_touch ${FSU_IMG} dir/b
    ${FSU_DIR}/src/fsu_mkdir/fsu_mkdir ${FSU_IMG} dir/c

    echo a >>expout
    echo b >>expout
    echo c >>expout
    atf_check '${FSU_DIR}/src/fsu_ls/fsu_ls ${FSU_IMG} dir | grep -v sysctl_createv' \
	0 expout ignore
}
noflags_cleanup() {
    ${FSU_DIR}/src/fsu_rm/fsu_rm ${FSU_IMG} -- -r dir
}

atf_test_case Fflag
Fflag_head() {
    atf_set "descr" "Checks that ls produces the correct output when" \
                    "using the -F option"
}
Fflag_body() {
    if [ -z "$FSU_DIR" -o -z "$FSU_IMG" ]; then
	atf_fail \
	    "variables: \$FSU_DIR and \$FSU_IMG should be set";
    fi
    ${FSU_DIR}/src/fsu_mkdir/fsu_mkdir ${FSU_IMG} dir
    ${FSU_DIR}/src/fsu_touch/fsu_touch ${FSU_IMG} dir/a
    ${FSU_DIR}/src/fsu_chmod/fsu_chmod ${FSU_IMG} +x dir/a
    ${FSU_DIR}/src/fsu_touch/fsu_touch ${FSU_IMG} dir/b
    ${FSU_DIR}/src/fsu_mkdir/fsu_mkdir ${FSU_IMG} dir/c

    echo "a*" >>expout
    echo b >>expout
    echo c/ >>expout
    atf_check '${FSU_DIR}/src/fsu_ls/fsu_ls ${FSU_IMG} -- -F dir | grep -v sysctl_createv' \
	0 expout ignore
}
Fflag_cleanup() {
    ${FSU_DIR}/src/fsu_rm/fsu_rm ${FSU_IMG} -- -r dir
}

atf_init_test_cases() {
    atf_add_test_case noflags
    atf_add_test_case Fflag
}
