"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mlPlugin = mlPlugin;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Used during the plugin's setup() lifecycle phase to register various client actions
 * representing ML plugin APIs. These are then exposed and used on the
 * server-side when processing node APIs - see server/routes/ml_routes_service
 * for examples.
 */
function mlPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.mlClient = components.clientAction.namespaceFactory();
  const mlClient = Client.prototype.mlClient.prototype;
  mlClient.searchModels = ca({
    url: {
      fmt: _common.ML_SEARCH_MODELS_ROUTE
    },
    needBody: true,
    method: 'POST'
  });
  mlClient.searchConnectors = ca({
    url: {
      fmt: _common.ML_SEARCH_CONNECTORS_ROUTE
    },
    needBody: true,
    method: 'POST'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29tbW9uIiwicmVxdWlyZSIsIm1sUGx1Z2luIiwiQ2xpZW50IiwiY29uZmlnIiwiY29tcG9uZW50cyIsImNhIiwiY2xpZW50QWN0aW9uIiwiZmFjdG9yeSIsInByb3RvdHlwZSIsIm1sQ2xpZW50IiwibmFtZXNwYWNlRmFjdG9yeSIsInNlYXJjaE1vZGVscyIsInVybCIsImZtdCIsIk1MX1NFQVJDSF9NT0RFTFNfUk9VVEUiLCJuZWVkQm9keSIsIm1ldGhvZCIsInNlYXJjaENvbm5lY3RvcnMiLCJNTF9TRUFSQ0hfQ09OTkVDVE9SU19ST1VURSJdLCJzb3VyY2VzIjpbIm1sX3BsdWdpbi50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7XG4gIE1MX1NFQVJDSF9DT05ORUNUT1JTX1JPVVRFLFxuICBNTF9TRUFSQ0hfTU9ERUxTX1JPVVRFLFxufSBmcm9tICcuLi8uLi9jb21tb24nO1xuXG4vKipcbiAqIFVzZWQgZHVyaW5nIHRoZSBwbHVnaW4ncyBzZXR1cCgpIGxpZmVjeWNsZSBwaGFzZSB0byByZWdpc3RlciB2YXJpb3VzIGNsaWVudCBhY3Rpb25zXG4gKiByZXByZXNlbnRpbmcgTUwgcGx1Z2luIEFQSXMuIFRoZXNlIGFyZSB0aGVuIGV4cG9zZWQgYW5kIHVzZWQgb24gdGhlXG4gKiBzZXJ2ZXItc2lkZSB3aGVuIHByb2Nlc3Npbmcgbm9kZSBBUElzIC0gc2VlIHNlcnZlci9yb3V0ZXMvbWxfcm91dGVzX3NlcnZpY2VcbiAqIGZvciBleGFtcGxlcy5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIG1sUGx1Z2luKENsaWVudDogYW55LCBjb25maWc6IGFueSwgY29tcG9uZW50czogYW55KSB7XG4gIGNvbnN0IGNhID0gY29tcG9uZW50cy5jbGllbnRBY3Rpb24uZmFjdG9yeTtcblxuICBDbGllbnQucHJvdG90eXBlLm1sQ2xpZW50ID0gY29tcG9uZW50cy5jbGllbnRBY3Rpb24ubmFtZXNwYWNlRmFjdG9yeSgpO1xuICBjb25zdCBtbENsaWVudCA9IENsaWVudC5wcm90b3R5cGUubWxDbGllbnQucHJvdG90eXBlO1xuXG4gIG1sQ2xpZW50LnNlYXJjaE1vZGVscyA9IGNhKHtcbiAgICB1cmw6IHtcbiAgICAgIGZtdDogTUxfU0VBUkNIX01PREVMU19ST1VURSxcbiAgICB9LFxuICAgIG5lZWRCb2R5OiB0cnVlLFxuICAgIG1ldGhvZDogJ1BPU1QnLFxuICB9KTtcblxuICBtbENsaWVudC5zZWFyY2hDb25uZWN0b3JzID0gY2Eoe1xuICAgIHVybDoge1xuICAgICAgZm10OiBNTF9TRUFSQ0hfQ09OTkVDVE9SU19ST1VURSxcbiAgICB9LFxuICAgIG5lZWRCb2R5OiB0cnVlLFxuICAgIG1ldGhvZDogJ1BPU1QnLFxuICB9KTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBS0EsSUFBQUEsT0FBQSxHQUFBQyxPQUFBO0FBTEE7QUFDQTtBQUNBO0FBQ0E7O0FBT0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ08sU0FBU0MsUUFBUUEsQ0FBQ0MsTUFBVyxFQUFFQyxNQUFXLEVBQUVDLFVBQWUsRUFBRTtFQUNsRSxNQUFNQyxFQUFFLEdBQUdELFVBQVUsQ0FBQ0UsWUFBWSxDQUFDQyxPQUFPO0VBRTFDTCxNQUFNLENBQUNNLFNBQVMsQ0FBQ0MsUUFBUSxHQUFHTCxVQUFVLENBQUNFLFlBQVksQ0FBQ0ksZ0JBQWdCLENBQUMsQ0FBQztFQUN0RSxNQUFNRCxRQUFRLEdBQUdQLE1BQU0sQ0FBQ00sU0FBUyxDQUFDQyxRQUFRLENBQUNELFNBQVM7RUFFcERDLFFBQVEsQ0FBQ0UsWUFBWSxHQUFHTixFQUFFLENBQUM7SUFDekJPLEdBQUcsRUFBRTtNQUNIQyxHQUFHLEVBQUVDO0lBQ1AsQ0FBQztJQUNEQyxRQUFRLEVBQUUsSUFBSTtJQUNkQyxNQUFNLEVBQUU7RUFDVixDQUFDLENBQUM7RUFFRlAsUUFBUSxDQUFDUSxnQkFBZ0IsR0FBR1osRUFBRSxDQUFDO0lBQzdCTyxHQUFHLEVBQUU7TUFDSEMsR0FBRyxFQUFFSztJQUNQLENBQUM7SUFDREgsUUFBUSxFQUFFLElBQUk7SUFDZEMsTUFBTSxFQUFFO0VBQ1YsQ0FBQyxDQUFDO0FBQ0oifQ==