"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addNotificationsMethods = addNotificationsMethods;
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function addNotificationsMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.GET_CHANNEl] = createAction({
    url: {
      fmt: '/_plugins/_notifications/configs/<%=id%>',
      req: {
        id: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_CHANNElS] = createAction({
    url: {
      fmt: '/_plugins/_notifications/channels'
    },
    needBody: false,
    method: 'GET'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_FEATURES] = createAction({
    url: {
      fmt: '/_plugins/_notifications/features'
    },
    needBody: false,
    method: 'GET'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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