"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleError = void 0;
var _errors = require("./errors");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// eslint-disable-next-line @typescript-eslint/no-explicit-any
const handleError = (e, res, logger) => {
  logger.error('Error occurred', e);
  // Handle specific type of Errors
  if (e instanceof _errors.AgentNotFoundError) {
    return res.notFound({
      body: 'Agent not found'
    });
  }

  // handle http response error of calling backend API
  if (e.statusCode) {
    if (e.statusCode >= 400 && e.statusCode <= 499) {
      return res.customError({
        body: {
          message: typeof e.body === 'string' ? e.body : JSON.stringify(e.body)
        },
        statusCode: e.statusCode
      });
    } else {
      return res.customError({
        statusCode: e.statusCode
      });
    }
  }

  // Return an general internalError for unhandled server-side issues
  return res.internalError();
};
exports.handleError = handleError;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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