/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocks;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.SpecialEdgeAttr;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.blocks.BlockSplitter;
import jadx.core.utils.ListUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class FixMultiEntryLoops {
    public static boolean process(MethodNode mth) {
        try {
            FixMultiEntryLoops.detectSpecialEdges(mth);
        }
        catch (Exception e2) {
            mth.addWarnComment("Failed to detect multi-entry loops", e2);
            return false;
        }
        List specialEdges = mth.getAll(AType.SPECIAL_EDGE);
        List multiEntryLoops = specialEdges.stream().filter(e -> e.getType() == SpecialEdgeAttr.SpecialEdgeType.BACK_EDGE).filter(e -> !FixMultiEntryLoops.isSingleEntryLoop(e)).collect(Collectors.toList());
        if (multiEntryLoops.isEmpty()) {
            return false;
        }
        try {
            List<SpecialEdgeAttr> crossEdges = ListUtils.filter(specialEdges, e -> e.getType() == SpecialEdgeAttr.SpecialEdgeType.CROSS_EDGE);
            boolean changed = false;
            for (SpecialEdgeAttr backEdge : multiEntryLoops) {
                changed |= FixMultiEntryLoops.fixLoop(mth, backEdge, crossEdges);
            }
            return changed;
        }
        catch (Exception e3) {
            mth.addWarnComment("Failed to fix multi-entry loops", e3);
            return false;
        }
    }

    private static boolean fixLoop(MethodNode mth, SpecialEdgeAttr backEdge, List<SpecialEdgeAttr> crossEdges) {
        BlockNode header = backEdge.getEnd();
        BlockNode headerIDom = header.getIDom();
        SpecialEdgeAttr subEntry = ListUtils.filterOnlyOne(crossEdges, e -> e.getStart() == headerIDom);
        if (subEntry == null || !FixMultiEntryLoops.isSupportedPattern(header, subEntry)) {
            mth.addWarnComment("Unsupported multi-entry loop pattern (" + backEdge + "). Please submit an issue!!!");
            return false;
        }
        BlockNode loopEnd = backEdge.getStart();
        BlockNode subEntryBlock = subEntry.getEnd();
        BlockNode copyHeader = BlockSplitter.insertBlockBetween(mth, loopEnd, header);
        BlockSplitter.copyBlockData(header, copyHeader);
        BlockSplitter.replaceConnection(copyHeader, header, subEntryBlock);
        mth.addDebugComment("Duplicate block to fix multi-entry loop: " + backEdge);
        return true;
    }

    private static boolean isSupportedPattern(BlockNode header, SpecialEdgeAttr subEntry) {
        return ListUtils.isSingleElement(header.getSuccessors(), subEntry.getEnd());
    }

    private static boolean isSingleEntryLoop(SpecialEdgeAttr e) {
        BlockNode loopEnd;
        BlockNode header = e.getEnd();
        return header == (loopEnd = e.getStart()) || loopEnd.getDoms().get(header.getId());
    }

    private static void detectSpecialEdges(MethodNode mth) {
        List<BlockNode> blocks = mth.getBasicBlocks();
        BlockColor[] colors = new BlockColor[blocks.size()];
        Arrays.fill((Object[])colors, (Object)BlockColor.WHITE);
        FixMultiEntryLoops.colorDFS(mth, blocks, colors, mth.getEnterBlock().getId());
    }

    private static void colorDFS(MethodNode mth, List<BlockNode> blocks, BlockColor[] colors, int cur) {
        colors[cur] = BlockColor.GRAY;
        BlockNode block = blocks.get(cur);
        for (BlockNode v : block.getSuccessors()) {
            int vId = v.getId();
            switch (colors[vId]) {
                case WHITE: {
                    FixMultiEntryLoops.colorDFS(mth, blocks, colors, vId);
                    break;
                }
                case GRAY: {
                    mth.addAttr(AType.SPECIAL_EDGE, new SpecialEdgeAttr(SpecialEdgeAttr.SpecialEdgeType.BACK_EDGE, block, v));
                    break;
                }
                case BLACK: {
                    mth.addAttr(AType.SPECIAL_EDGE, new SpecialEdgeAttr(SpecialEdgeAttr.SpecialEdgeType.CROSS_EDGE, block, v));
                }
            }
        }
        colors[cur] = BlockColor.BLACK;
    }

    private static enum BlockColor {
        WHITE,
        GRAY,
        BLACK;

    }
}

