/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.utils.StringUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.jobs.ITaskProgress;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.utils.Icons;
import jadx.gui.utils.NLS;
import jadx.gui.utils.OverlayIcon;
import jadx.gui.utils.SystemInfo;
import java.awt.Component;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.TestOnly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UiUtils.class);
    public static final long MIN_FREE_MEMORY = UiUtils.calculateMinFreeMemory();
    public static final int CTRL_BNT_KEY = UiUtils.getCtrlButton();

    private UiUtils() {
    }

    public static FlatSVGIcon openSvgIcon(String name) {
        boolean found;
        String iconPath = "icons/" + name + ".svg";
        FlatSVGIcon icon = new FlatSVGIcon(iconPath);
        try {
            found = icon.hasFound();
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to load icon: " + iconPath, (Throwable)e);
        }
        if (!found) {
            throw new JadxRuntimeException("Icon not found: " + iconPath);
        }
        return icon;
    }

    public static ImageIcon openIcon(String name) {
        String iconPath = "/icons-16/" + name + ".png";
        URL resource = UiUtils.class.getResource(iconPath);
        if (resource == null) {
            throw new JadxRuntimeException("Icon not found: " + iconPath);
        }
        return new ImageIcon(resource);
    }

    public static Image openImage(String path) {
        URL resource = UiUtils.class.getResource(path);
        if (resource == null) {
            throw new JadxRuntimeException("Image not found: " + path);
        }
        return Toolkit.getDefaultToolkit().createImage(resource);
    }

    public static void addKeyBinding(JComponent comp, KeyStroke key, String id, final Runnable action) {
        UiUtils.addKeyBinding(comp, key, id, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.run();
            }
        });
    }

    public static void addKeyBinding(JComponent comp, KeyStroke key, String id, Action action) {
        comp.getInputMap().put(key, id);
        comp.getActionMap().put(id, action);
    }

    public static void removeKeyBinding(JComponent comp, KeyStroke key, String id) {
        comp.getInputMap().remove(key);
        comp.getActionMap().remove(id);
    }

    public static String typeFormat(String name, ArgType type) {
        return name + " " + UiUtils.typeStr(type);
    }

    public static String typeFormatHtml(String name, ArgType type) {
        return UiUtils.wrapHtml(UiUtils.escapeHtml(name) + ' ' + UiUtils.fadeHtml(UiUtils.escapeHtml(UiUtils.typeStr(type))));
    }

    public static String fadeHtml(String htmlStr) {
        return "<span style='color:#888888;'>" + htmlStr + "</span>";
    }

    public static String wrapHtml(String htmlStr) {
        return "<html><body><nobr>" + htmlStr + "</nobr></body></html>";
    }

    public static String escapeHtml(String str) {
        return str.replace("<", "&lt;").replace(">", "&gt;");
    }

    public static String typeStr(ArgType type) {
        if (type == null) {
            return "null";
        }
        if (type.isObject()) {
            if (type.isGenericType()) {
                return type.getObject();
            }
            ArgType wt = type.getWildcardType();
            if (wt != null) {
                ArgType.WildcardBound bound = type.getWildcardBound();
                if (bound == ArgType.WildcardBound.UNBOUND) {
                    return bound.getStr();
                }
                return bound.getStr() + UiUtils.typeStr(wt);
            }
            String objName = UiUtils.objectShortName(type.getObject());
            ArgType outerType = type.getOuterType();
            if (outerType != null) {
                return UiUtils.typeStr(outerType) + '.' + objName;
            }
            List genericTypes = type.getGenericTypes();
            if (genericTypes != null) {
                String generics = Utils.listToString((Iterable)genericTypes, (String)", ", UiUtils::typeStr);
                return objName + '<' + generics + '>';
            }
            return objName;
        }
        if (type.isArray()) {
            return UiUtils.typeStr(type.getArrayElement()) + "[]";
        }
        return type.toString();
    }

    private static String objectShortName(String obj) {
        int dot = obj.lastIndexOf(46);
        if (dot != -1) {
            return obj.substring(dot + 1);
        }
        return obj;
    }

    public static OverlayIcon makeIcon(AccessInfo af, Icon pub, Icon pri, Icon pro, Icon def) {
        Icon icon = af.isPublic() ? pub : (af.isPrivate() ? pri : (af.isProtected() ? pro : def));
        OverlayIcon overIcon = new OverlayIcon(icon);
        if (af.isFinal()) {
            overIcon.add(Icons.FINAL);
        }
        if (af.isStatic()) {
            overIcon.add(Icons.STATIC);
        }
        return overIcon;
    }

    public static long calculateMinFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        long minFree = (long)((double)runtime.maxMemory() * 0.2);
        return Math.min(minFree, 0x20000000L);
    }

    public static boolean isFreeMemoryAvailable() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long totalFree = runtime.freeMemory() + (maxMemory - runtime.totalMemory());
        return totalFree > MIN_FREE_MEMORY;
    }

    public static String memoryInfo() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return "heap: " + UiUtils.format(allocatedMemory - freeMemory) + ", allocated: " + UiUtils.format(allocatedMemory) + ", free: " + UiUtils.format(freeMemory) + ", total free: " + UiUtils.format(freeMemory + maxMemory - allocatedMemory) + ", max: " + UiUtils.format(maxMemory);
    }

    private static String format(long mem) {
        return (long)((double)mem / 1048576.0) + "MB";
    }

    public static void setClipboardString(String text) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection transferable = new StringSelection(text);
            clipboard.setContents(transferable, null);
            LOG.debug("String '{}' copied to clipboard", (Object)text);
        }
        catch (Exception e) {
            LOG.error("Failed copy string '{}' to clipboard", (Object)text, (Object)e);
        }
    }

    public static void setWindowIcons(Window window) {
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(UiUtils.openImage("/logos/jadx-logo-16px.png"));
        icons.add(UiUtils.openImage("/logos/jadx-logo-32px.png"));
        icons.add(UiUtils.openImage("/logos/jadx-logo-48px.png"));
        icons.add(UiUtils.openImage("/logos/jadx-logo.png"));
        window.setIconImages(icons);
    }

    private static int getCtrlButton() {
        if (SystemInfo.IS_MAC) {
            return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        return 128;
    }

    public static int ctrlButton() {
        return CTRL_BNT_KEY;
    }

    public static boolean isCtrlDown(KeyEvent keyEvent) {
        return keyEvent.getModifiersEx() == CTRL_BNT_KEY;
    }

    public static <T extends Window> void addEscapeShortCutToDispose(T window) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        ((RootPaneContainer)((Object)window)).getRootPane().registerKeyboardAction(e -> window.dispose(), stroke, 2);
    }

    public static int getOffsetAtMousePosition(AbstractCodeArea codeArea) {
        try {
            Point mousePos = UiUtils.getMousePosition((Component)((Object)codeArea));
            return codeArea.viewToModel(mousePos);
        }
        catch (Exception e) {
            LOG.error("Failed to get offset at mouse position", (Throwable)e);
            return -1;
        }
    }

    public static Point getMousePosition(Component comp) {
        Point pos = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(pos, comp);
        return pos;
    }

    public static String getEnvVar(String varName, String defValue) {
        String envVal = System.getenv(varName);
        if (envVal == null) {
            return defValue;
        }
        return envVal;
    }

    public static void showMessageBox(Component parent, String msg) {
        JOptionPane.showMessageDialog(parent, msg);
    }

    public static void errorMessage(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, NLS.str("message.errorTitle"), 0);
    }

    public static void copyToClipboard(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return;
        }
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection selection = new StringSelection(text);
            clipboard.setContents(selection, selection);
        }
        catch (Exception e) {
            LOG.error("Failed copy text to clipboard", (Throwable)e);
        }
    }

    public static void resetClipboardOwner() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemSelection();
            if (clipboard != null) {
                StringSelection selection = new StringSelection("");
                clipboard.setContents(selection, selection);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to reset clipboard owner", (Throwable)e);
        }
    }

    public static int calcProgress(ITaskProgress taskProgress) {
        return UiUtils.calcProgress(taskProgress.progress(), taskProgress.total());
    }

    public static int calcProgress(long done, long total) {
        if (done > total) {
            LOG.debug("Task progress has invalid values: done={}, total={}", (Object)done, (Object)total);
            return 100;
        }
        return Math.round((float)(done * 100L) / (float)total);
    }

    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void uiRun(Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public static void uiRunAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e) {
            LOG.warn("UI thread interrupted, runnable: {}", (Object)runnable, (Object)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void uiThreadGuard() {
        if (!SwingUtilities.isEventDispatchThread()) {
            LOG.warn("Expect UI thread, got: {}", (Object)Thread.currentThread(), (Object)new JadxRuntimeException(new String[0]));
        }
    }

    public static void notUiThreadGuard() {
        if (SwingUtilities.isEventDispatchThread()) {
            LOG.warn("Expect background thread, got: {}", (Object)Thread.currentThread(), (Object)new JadxRuntimeException(new String[0]));
        }
    }

    @TestOnly
    public static void debugTimer(int periodInSeconds, final Runnable action) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                action.run();
            }
        }, 0L, (long)periodInSeconds * 1000L);
    }

    @TestOnly
    public static void printStackTrace(String label) {
        LOG.debug("StackTrace: {}", (Object)label, (Object)new Exception(label));
    }
}

