/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.attributes;

import jadx.api.plugins.input.data.annotations.AnnotationVisibility;
import jadx.api.plugins.input.data.annotations.EncodedType;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.impl.JadxFieldRef;
import jadx.plugins.input.java.data.ConstPoolReader;
import jadx.plugins.input.java.data.DataReader;
import jadx.plugins.input.java.data.JavaClassData;
import jadx.plugins.input.java.data.attributes.types.JavaAnnotationsAttr;
import jadx.plugins.input.java.utils.JavaClassParseException;
import java.util.ArrayList;

public class EncodedValueReader {
    public static EncodedValue read(JavaClassData clsData, DataReader reader) {
        ConstPoolReader constPool = clsData.getConstPoolReader();
        char tag = (char)reader.readU1();
        switch (tag) {
            case 'B': {
                return new EncodedValue(EncodedType.ENCODED_BYTE, (Object)((byte)constPool.getInt(reader.readU2())));
            }
            case 'C': {
                return new EncodedValue(EncodedType.ENCODED_CHAR, (Object)Character.valueOf((char)constPool.getInt(reader.readU2())));
            }
            case 'D': {
                return new EncodedValue(EncodedType.ENCODED_DOUBLE, (Object)constPool.getDouble(reader.readU2()));
            }
            case 'F': {
                return new EncodedValue(EncodedType.ENCODED_FLOAT, (Object)Float.valueOf(constPool.getFloat(reader.readU2())));
            }
            case 'I': {
                return new EncodedValue(EncodedType.ENCODED_INT, (Object)constPool.getInt(reader.readU2()));
            }
            case 'J': {
                return new EncodedValue(EncodedType.ENCODED_LONG, (Object)constPool.getLong(reader.readU2()));
            }
            case 'S': {
                return new EncodedValue(EncodedType.ENCODED_SHORT, (Object)((short)constPool.getInt(reader.readU2())));
            }
            case 'Z': {
                return new EncodedValue(EncodedType.ENCODED_BOOLEAN, (Object)(1 == constPool.getInt(reader.readU2()) ? 1 : 0));
            }
            case 's': {
                return new EncodedValue(EncodedType.ENCODED_STRING, (Object)constPool.getUtf8(reader.readU2()));
            }
            case 'e': {
                String cls = constPool.getUtf8(reader.readU2());
                String name = constPool.getUtf8(reader.readU2());
                return new EncodedValue(EncodedType.ENCODED_ENUM, (Object)new JadxFieldRef(cls, name, cls));
            }
            case 'c': {
                return new EncodedValue(EncodedType.ENCODED_TYPE, (Object)constPool.getUtf8(reader.readU2()));
            }
            case '@': {
                return new EncodedValue(EncodedType.ENCODED_ANNOTATION, (Object)JavaAnnotationsAttr.readAnnotation(AnnotationVisibility.RUNTIME, clsData, reader));
            }
            case '[': {
                int len = reader.readU2();
                ArrayList<EncodedValue> values = new ArrayList<EncodedValue>(len);
                for (int i = 0; i < len; ++i) {
                    values.add(EncodedValueReader.read(clsData, reader));
                }
                return new EncodedValue(EncodedType.ENCODED_ARRAY, values);
            }
        }
        throw new JavaClassParseException("Unknown element value tag: " + tag);
    }
}

