'''OpenGL extension QCOM.motion_estimation

This module customises the behaviour of the 
OpenGL.raw.GLES2.QCOM.motion_estimation to provide a more 
Python-friendly API

Overview (from the spec)
	
	Motion estimation, also referred to as optical flow, is the process of
	producing motion vectors that convey the 2D transformation from a reference
	image to a target image.  There are various uses of motion estimation, such as
	frame extrapolation, compression, object tracking, etc.
	
	This extension adds support for motion estimation in OpenGL ES by adding
	functions which take the reference and target images and populate an
	output texture containing the corresponding motion vectors.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/QCOM/motion_estimation.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.QCOM.motion_estimation import *
from OpenGL.raw.GLES2.QCOM.motion_estimation import _EXTENSION_NAME

def glInitMotionEstimationQCOM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION