/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.converters.TransportHandlerTypeConverter;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.connection.InboundConnection;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;
import de.rub.nds.tlsattacker.transport.TransportHandlerType;

public class TransportHandlerDelegate
extends Delegate {
    @Parameter(names={"-transport_handler_type"}, description="Transport Handler type", converter=TransportHandlerTypeConverter.class)
    private TransportHandlerType transportHandlerType = null;

    public TransportHandlerType getTransportHandlerType() {
        return this.transportHandlerType;
    }

    public void setTransportHandlerType(TransportHandlerType transportHandlerType) {
        this.transportHandlerType = transportHandlerType;
    }

    @Override
    public void applyDelegate(Config config) {
        if (this.transportHandlerType == null) {
            return;
        }
        if (config.getDefaultClientConnection() == null) {
            config.setDefaultClientConnection(new OutboundConnection());
        }
        if (config.getDefaultServerConnection() == null) {
            config.setDefaultServerConnection(new InboundConnection());
        }
        config.getDefaultClientConnection().setTransportHandlerType(this.transportHandlerType);
        config.getDefaultServerConnection().setTransportHandlerType(this.transportHandlerType);
    }
}

