/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.url;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractFileNameParser;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.URLFileNameParser;
import org.apache.commons.vfs.provider.VfsComponentContext;
import org.apache.commons.vfs.provider.local.GenericFileNameParser;

public class UrlFileNameParser
extends AbstractFileNameParser {
    private URLFileNameParser url = new URLFileNameParser(80);
    private GenericFileNameParser generic = new GenericFileNameParser();

    public boolean encodeCharacter(char ch) {
        return super.encodeCharacter(ch) || ch == '?';
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        if (this.isUrlBased(base, filename)) {
            return this.url.parseUri(context, base, filename);
        }
        return this.generic.parseUri(context, base, filename);
    }

    protected boolean isUrlBased(FileName base, String filename) {
        if (base instanceof URLFileName) {
            return true;
        }
        int nuofSlash = this.countSlashes(filename);
        return nuofSlash == 2;
    }

    protected int countSlashes(String filename) {
        int state = 0;
        int nuofSlash = 0;
        for (int pos = 0; pos < filename.length(); ++pos) {
            char c = filename.charAt(pos);
            if (state == 0) {
                if (c >= 'a' && c <= 'z' || c != ':') continue;
                ++state;
                continue;
            }
            if (state != true) continue;
            if (c == '/') {
                ++nuofSlash;
                continue;
            }
            return nuofSlash;
        }
        return nuofSlash;
    }
}

