/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class LiteralFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            LiteralFixer.$$$reportNull$$$0(0);
        }
        if (astNode.getElementType() == JavaTokenType.STRING_LITERAL && !StringUtil.endsWithChar((CharSequence)astNode.getText(), (char)'\"')) {
            editor.getDocument().insertString(astNode.getTextRange().getEndOffset(), (CharSequence)"\"");
        } else if (astNode.getElementType() == JavaTokenType.CHARACTER_LITERAL && !StringUtil.endsWithChar((CharSequence)astNode.getText(), (char)'\'')) {
            editor.getDocument().insertString(astNode.getTextRange().getEndOffset(), (CharSequence)"'");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/codeInsight/editorActions/smartEnter/LiteralFixer", "apply"));
    }
}

