/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.analysis;

import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.analysis.AnalysisUtils;
import com.intellij.coverage.analysis.CoverageInfoCollector;
import com.intellij.coverage.analysis.JavaCoverageClassesEnumerator;
import com.intellij.coverage.analysis.PackageAnnotator;
import com.intellij.coverage.analysis.RequestRoot;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JavaCoverageClassesAnnotator
extends JavaCoverageClassesEnumerator {
    private static final Logger LOG = Logger.getInstance(JavaCoverageClassesAnnotator.class);
    private final CoverageInfoCollector myCollector;
    private final ProjectData myProjectData;
    private final Map<String, PackageAnnotator.AtomicPackageCoverageInfo> myFlattenPackages;
    private final Map<VirtualFile, PackageAnnotator.AtomicPackageCoverageInfo> myFlattenDirectories;
    private ExecutorService myExecutor;
    private int myThreadsCount;
    private final PackageAnnotator myPackageAnnotator;

    public JavaCoverageClassesAnnotator(@NotNull CoverageSuitesBundle suite, @NotNull Project project, @NotNull CoverageInfoCollector collector) {
        if (suite == null) {
            JavaCoverageClassesAnnotator.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JavaCoverageClassesAnnotator.$$$reportNull$$$0(1);
        }
        if (collector == null) {
            JavaCoverageClassesAnnotator.$$$reportNull$$$0(2);
        }
        super(suite, project);
        this.myFlattenPackages = new ConcurrentHashMap<String, PackageAnnotator.AtomicPackageCoverageInfo>();
        this.myFlattenDirectories = new ConcurrentHashMap<VirtualFile, PackageAnnotator.AtomicPackageCoverageInfo>();
        this.myCollector = collector;
        this.myProjectData = this.mySuite.getCoverageData();
        this.myPackageAnnotator = new PackageAnnotator(suite, project, this.myProjectData);
    }

    @Override
    public void visitSuite() {
        if (this.myProjectData == null) {
            return;
        }
        this.myFlattenPackages.clear();
        boolean created = this.initExecutor();
        super.visitSuite();
        if (created) {
            this.stopExecutor();
        }
        this.collectPackageCoverage();
    }

    private void collectPackageCoverage() {
        HashMap<String, PackageAnnotator.PackageCoverageInfo> flattenPackages = new HashMap<String, PackageAnnotator.PackageCoverageInfo>();
        for (Map.Entry<String, PackageAnnotator.AtomicPackageCoverageInfo> entry : this.myFlattenPackages.entrySet()) {
            String packageFQName = AnalysisUtils.internalNameToFqn(entry.getKey());
            PackageAnnotator.PackageCoverageInfo info = entry.getValue().toPackageCoverageInfo();
            flattenPackages.put(packageFQName, info);
        }
        this.myFlattenPackages.clear();
        JavaCoverageClassesAnnotator.annotatePackages(flattenPackages, this.myCollector);
    }

    public static void annotatePackages(Map<String, PackageAnnotator.PackageCoverageInfo> flattenPackages, CoverageInfoCollector collector) {
        HashMap<String, PackageAnnotator.PackageCoverageInfo> packages = new HashMap<String, PackageAnnotator.PackageCoverageInfo>();
        for (Map.Entry<String, PackageAnnotator.PackageCoverageInfo> entry : flattenPackages.entrySet()) {
            String packageFQName = entry.getKey();
            PackageAnnotator.PackageCoverageInfo info = entry.getValue();
            collector.addPackage(packageFQName, info, true);
            while (!packageFQName.isEmpty()) {
                packages.computeIfAbsent(packageFQName, k -> new PackageAnnotator.PackageCoverageInfo()).append(info);
                int index = packageFQName.lastIndexOf(46);
                if (index < 0) break;
                packageFQName = packageFQName.substring(0, index);
            }
            packages.computeIfAbsent("", k -> new PackageAnnotator.PackageCoverageInfo()).append(info);
        }
        for (Map.Entry<String, PackageAnnotator.PackageCoverageInfo> entry : packages.entrySet()) {
            collector.addPackage(entry.getKey(), entry.getValue(), false);
        }
    }

    @Override
    protected void visitSource(Module module, String rootPackageVMName, List<RequestRoot> roots) {
        this.myFlattenDirectories.clear();
        if (module.isDisposed()) {
            LOG.warn("Module is already disposed: " + String.valueOf(module));
            return;
        }
        super.visitSource(module, rootPackageVMName, roots);
        this.syncPoolThreads();
        this.collectDirectoryCoverage(module, rootPackageVMName);
    }

    private void collectDirectoryCoverage(Module module, String packageVMName) {
        HashMap<VirtualFile, PackageAnnotator.PackageCoverageInfo> flattenDirectories = new HashMap<VirtualFile, PackageAnnotator.PackageCoverageInfo>();
        for (Map.Entry<VirtualFile, PackageAnnotator.AtomicPackageCoverageInfo> entry : this.myFlattenDirectories.entrySet()) {
            flattenDirectories.put(entry.getKey(), entry.getValue().toPackageCoverageInfo());
        }
        this.myFlattenDirectories.clear();
        JavaCoverageClassesAnnotator.annotateDirectories(flattenDirectories, this.myCollector, JavaCoverageClassesAnnotator.getPackageRoots(module, packageVMName));
    }

    public static void annotateDirectories(Map<VirtualFile, PackageAnnotator.PackageCoverageInfo> flattenDirectories, CoverageInfoCollector collector, Set<VirtualFile> sourceRoots) {
        HashMap<VirtualFile, PackageAnnotator.DirCoverageInfo> directories = new HashMap<VirtualFile, PackageAnnotator.DirCoverageInfo>();
        block0: for (Map.Entry<VirtualFile, PackageAnnotator.PackageCoverageInfo> entry : flattenDirectories.entrySet()) {
            PackageAnnotator.PackageCoverageInfo info = entry.getValue();
            for (VirtualFile dir = entry.getKey(); dir != null; dir = dir.getParent()) {
                directories.computeIfAbsent(dir, PackageAnnotator.DirCoverageInfo::new).append(info);
                if (sourceRoots.contains(dir)) continue block0;
            }
        }
        for (PackageAnnotator.DirCoverageInfo dir : directories.values()) {
            collector.addSourceDirectory(dir.sourceRoot, dir);
        }
    }

    @Override
    protected void visitClassFiles(String toplevelClassSrcFQName, List<File> files, String packageVMName) {
        if (this.isClassExcluded(toplevelClassSrcFQName)) {
            return;
        }
        Map children = files.stream().filter(Predicate.not(this::ignoreClass)).collect(Collectors.toMap(AnalysisUtils::getClassName, Function.identity()));
        if (children.isEmpty()) {
            return;
        }
        this.myExecutor.execute(() -> {
            PackageAnnotator.Result result = this.myPackageAnnotator.visitFiles(toplevelClassSrcFQName, children, packageVMName);
            if (result != null) {
                this.annotateClass(toplevelClassSrcFQName, result.info, packageVMName, result.directory);
            }
        });
    }

    private void annotateClass(String toplevelClassSrcFQName, PackageAnnotator.ClassCoverageInfo info, String packageVMName, VirtualFile directory) {
        this.myCollector.addClass(toplevelClassSrcFQName, info);
        this.getOrCreateFlattenPackage(packageVMName).append(info);
        if (directory != null) {
            this.getOrCreateFlattenDirectory(directory).append(info);
        }
    }

    private void syncPoolThreads() {
        CyclicBarrier barrier = new CyclicBarrier(this.myThreadsCount + 1);
        for (int i = 0; i < this.myThreadsCount; ++i) {
            this.myExecutor.execute(() -> JavaCoverageClassesAnnotator.waitBarrier(barrier));
        }
        JavaCoverageClassesAnnotator.waitBarrier(barrier);
    }

    private static void waitBarrier(CyclicBarrier barrier) {
        try {
            barrier.await();
        }
        catch (InterruptedException | BrokenBarrierException exception) {
            // empty catch block
        }
    }

    private void stopExecutor() {
        this.myExecutor.shutdown();
        try {
            this.myExecutor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.myExecutor = null;
        }
    }

    private boolean initExecutor() {
        if (this.myExecutor != null) {
            return false;
        }
        this.myThreadsCount = JavaCoverageClassesAnnotator.getWorkingThreads();
        this.myExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Coverage Loading", (int)this.myThreadsCount);
        return true;
    }

    private PackageAnnotator.AtomicPackageCoverageInfo getOrCreateFlattenPackage(@NotNull String packageName) {
        if (packageName == null) {
            JavaCoverageClassesAnnotator.$$$reportNull$$$0(3);
        }
        return this.myFlattenPackages.computeIfAbsent(packageName, k -> new PackageAnnotator.AtomicPackageCoverageInfo());
    }

    private PackageAnnotator.AtomicPackageCoverageInfo getOrCreateFlattenDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            JavaCoverageClassesAnnotator.$$$reportNull$$$0(4);
        }
        return this.myFlattenDirectories.computeIfAbsent(file, k -> new PackageAnnotator.AtomicPackageCoverageInfo());
    }

    private boolean ignoreClass(File child) {
        for (JavaCoverageEngineExtension extension : (JavaCoverageEngineExtension[])JavaCoverageEngineExtension.EP_NAME.getExtensions()) {
            if (!extension.ignoreCoverageForClass(this.mySuite, child)) continue;
            return true;
        }
        return false;
    }

    private boolean isClassExcluded(String fqn) {
        return ContainerUtil.all((Object[])this.mySuite.getSuites(), suite -> {
            JavaCoverageSuite javaSuite;
            return suite instanceof JavaCoverageSuite && !(javaSuite = (JavaCoverageSuite)((Object)suite)).isClassFiltered(fqn);
        });
    }

    private static Set<VirtualFile> getPackageRoots(Module module, String rootPackageVMName) {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (SourceFolder folder : JavaCoverageClassesAnnotator.getSourceFolders(module)) {
            String prefix;
            VirtualFile relativeSrcRoot;
            VirtualFile file = folder.getFile();
            if (file == null || (relativeSrcRoot = file.findFileByRelativePath(StringUtil.trimStart((String)rootPackageVMName, (String)(prefix = AnalysisUtils.fqnToInternalName(folder.getPackagePrefix()))))) == null) continue;
            result.add(relativeSrcRoot);
        }
        return result;
    }

    private static Set<SourceFolder> getSourceFolders(Module module) {
        ContentEntry[] contentEntries;
        HashSet<SourceFolder> result = new HashSet<SourceFolder>();
        for (ContentEntry contentEntry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (SourceFolder folder : contentEntry.getSourceFolders()) {
                if (folder.getFile() == null) continue;
                result.add(folder);
            }
        }
        return result;
    }

    public static Set<VirtualFile> getSourceRoots(Module module) {
        return JavaCoverageClassesAnnotator.getSourceFolders(module).stream().map(ContentFolder::getFile).collect(Collectors.toSet());
    }

    private static int getWorkingThreads() {
        int threads = Registry.intValue((String)"idea.coverage.loading.threads");
        int maxThreads = Runtime.getRuntime().availableProcessors() - 1;
        if (threads == 0) {
            threads = maxThreads;
        }
        threads = Math.min(threads, maxThreads);
        threads = Math.max(threads, 1);
        return threads;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coverage/analysis/JavaCoverageClassesAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateFlattenPackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateFlattenDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

