/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.gnu.trove;

import java.io.Serializable;
import org.jetbrains.coverage.gnu.trove.HashFunctions;
import org.jetbrains.coverage.gnu.trove.TIntFunction;
import org.jetbrains.coverage.gnu.trove.TIntHash;
import org.jetbrains.coverage.gnu.trove.TIntHashingStrategy;
import org.jetbrains.coverage.gnu.trove.TIntIntIterator;
import org.jetbrains.coverage.gnu.trove.TIntIntProcedure;
import org.jetbrains.coverage.gnu.trove.TIntProcedure;

public class TIntIntHashMap
extends TIntHash
implements Serializable {
    protected transient int[] _values;

    public TIntIntHashMap() {
    }

    /*
     * WARNING - void declaration
     */
    public TIntIntHashMap(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntIntHashMap(int initialCapacity, float loadFactor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntIntHashMap(TIntHashingStrategy strategy) {
        super((TIntHashingStrategy)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntIntHashMap(int initialCapacity, TIntHashingStrategy strategy) {
        super((int)var1_1, (TIntHashingStrategy)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntIntHashMap(int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super((int)var1_1, (float)var2_2, (TIntHashingStrategy)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        void var1_1;
        TIntIntHashMap m = (TIntIntHashMap)super.clone();
        ((TIntIntHashMap)super.clone())._values = (int[])this._values.clone();
        return var1_1;
    }

    public TIntIntIterator iterator() {
        return new TIntIntIterator(this);
    }

    /*
     * WARNING - void declaration
     */
    protected int setUp(int initialCapacity) {
        void var1_1;
        int capacity = super.setUp(initialCapacity);
        this._values = new int[capacity];
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int put(int key, int value) {
        void var3_3;
        void var2_2;
        void var1_1;
        int previous = 0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = var1_1;
        this._states[index] = 1;
        this._values[index] = var2_2;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldKeys = this._set;
        int[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new int[newCapacity];
        this._values = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            void var2_2;
            if (oldStates[i] != 1) continue;
            int o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = var2_2;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int get(int key) {
        void var1_1;
        int index = this.index(key);
        if (index < 0) {
            return 0;
        }
        return this._values[var1_1];
    }

    public void clear() {
        super.clear();
        int[] keys = this._set;
        int[] vals = this._values;
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0;
            vals[i] = 0;
            states[i] = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int remove(int key) {
        void var2_2;
        int prev = 0;
        int index = this.index(key);
        if (index >= 0) {
            void var1_1;
            prev = this._values[index];
            this.removeAt((int)var1_1);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        if (!(other instanceof TIntIntHashMap)) {
            return false;
        }
        TIntIntHashMap that = (TIntIntHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure((TIntIntHashMap)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return var1_1.getHashCode();
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[var1_1] = 0;
    }

    /*
     * WARNING - void declaration
     */
    public int[] getValues() {
        void var1_1;
        int[] vals = new int[this.size()];
        int[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int[] keys() {
        void var1_1;
        int[] keys = new int[this.size()];
        int[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return var1_1;
    }

    public boolean containsValue(int val) {
        byte[] states = this._states;
        int[] vals = this._values;
        int i = this._values.length;
        while (i-- > 0) {
            if (states[i] != 1 || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(int key) {
        void var1_1;
        return this.contains((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean forEachKey(TIntProcedure procedure) {
        void var1_1;
        return this.forEach((TIntProcedure)var1_1);
    }

    public boolean forEachValue(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] values = this._values;
        int i = this._values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TIntIntProcedure procedure) {
        byte[] states = this._states;
        int[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean retainEntries(TIntIntProcedure procedure) {
        void var2_2;
        boolean modified = false;
        byte[] states = this._states;
        int[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return (boolean)var2_2;
    }

    public void transformValues(TIntFunction function) {
        byte[] states = this._states;
        int[] values = this._values;
        int i = this._values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean increment(int key) {
        void var1_1;
        return this.adjustValue((int)var1_1, 1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean adjustValue(int key, int amount) {
        void var2_2;
        void var1_1;
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        void v0 = var1_1;
        this._values[v0] = this._values[v0] + var2_2;
        return true;
    }

    private static final class EqProcedure
    implements TIntIntProcedure {
        private final TIntIntHashMap _otherMap;

        /*
         * WARNING - void declaration
         */
        EqProcedure(TIntIntHashMap otherMap) {
            void var1_1;
            this._otherMap = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean execute(int key, int value) {
            void var1_1;
            void var2_2;
            int n = this._otherMap.index(key);
            return n >= 0 && this.eq((int)var2_2, this._otherMap.get((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private final boolean eq(int v1, int v2) {
            void var2_2;
            return v1 == var2_2;
        }
    }

    private final class HashProcedure
    implements TIntIntProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public final int getHashCode() {
            return this.h;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean execute(int key, int value) {
            void var2_2;
            void var1_1;
            this.h += TIntIntHashMap.this._hashingStrategy.computeHashCode((int)var1_1) ^ HashFunctions.hash((int)var2_2);
            return true;
        }
    }
}

