/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.Gray;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class ProgressStripeIcon
implements Icon {
    private static final int TRANSLATE = 1;
    @NotNull
    private final JComponent myReferenceComponent;
    private final int myShift;

    private ProgressStripeIcon(@NotNull JComponent component, int shift) {
        if (component == null) {
            ProgressStripeIcon.$$$reportNull$$$0(0);
        }
        this.myReferenceComponent = component;
        this.myShift = shift;
    }

    public abstract int getChunkWidth();

    protected abstract void paint(@NotNull Graphics2D var1, int var2, int var3, int var4);

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        Graphics2D g2 = (Graphics2D)g;
        for (int shift = this.myShift - this.getChunkWidth(); shift < this.getIconWidth(); shift += this.getChunkWidth()) {
            this.paint(g2, x, y, shift);
        }
        config.restore();
    }

    @Override
    public int getIconWidth() {
        return this.myReferenceComponent.getWidth();
    }

    @NotNull
    public static AsyncProcessIcon generateIcon(final @NotNull JComponent component) {
        if (component == null) {
            ProgressStripeIcon.$$$reportNull$$$0(1);
        }
        ArrayList<GradientIcon> result2 = new ArrayList<GradientIcon>();
        for (int i = 0; i < 2 * JBUIScale.scale((int)128); i += JBUIScale.scale((int)1)) {
            result2.add(new GradientIcon(component, i));
        }
        final Icon passive = (Icon)result2.get(0);
        final AsyncProcessIcon icon = new AsyncProcessIcon("ProgressStripeIcon", result2.toArray(new Icon[0]), passive){

            public Dimension getPreferredSize() {
                return new Dimension(component.getWidth(), passive.getIconHeight());
            }
        };
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                icon.revalidate();
            }
        });
        AsyncProcessIcon asyncProcessIcon = icon;
        if (asyncProcessIcon == null) {
            ProgressStripeIcon.$$$reportNull$$$0(2);
        }
        return asyncProcessIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/ui/ProgressStripeIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/ui/ProgressStripeIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateIcon";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class GradientIcon
    extends ProgressStripeIcon {
        private static final int GRADIENT = 128;
        private static final int GRADIENT_HEIGHT = 3;

        private GradientIcon(@NotNull JComponent component, int shift) {
            if (component == null) {
                GradientIcon.$$$reportNull$$$0(0);
            }
            super(component, shift);
        }

        @Override
        public int getChunkWidth() {
            return 2 * JBUIScale.scale((int)128);
        }

        @Override
        public void paint(@NotNull Graphics2D g2, int x, int y, int shift) {
            if (g2 == null) {
                GradientIcon.$$$reportNull$$$0(1);
            }
            Object dark = UIUtil.isGraphite() ? Gray.xD4 : JBUI.CurrentTheme.ProgressBar.INDETERMINATE_START;
            Color light = UIUtil.isGraphite() ? new Color(10001054) : JBUI.CurrentTheme.ProgressBar.INDETERMINATE_END;
            g2.setPaint(new GradientPaint(x + shift, y, (Color)dark, x + shift + JBUIScale.scale((int)128), y, light));
            g2.fill(new Rectangle(x + shift, y, JBUIScale.scale((int)128), this.getIconHeight()));
            g2.setPaint(new GradientPaint(x + shift + JBUIScale.scale((int)128), y, light, x + shift + 2 * JBUIScale.scale((int)128), y, (Color)dark));
            g2.fill(new Rectangle(x + shift + JBUIScale.scale((int)128), y, JBUIScale.scale((int)128), this.getIconHeight()));
        }

        @Override
        public int getIconHeight() {
            return JBUIScale.scale((int)3);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/ui/ProgressStripeIcon$GradientIcon";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

