/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;

public interface PerforcePhysicalConnectionParametersI {
    public String getPathToExec();

    public String getPathToIgnore();

    public Project getProject();

    public void disable();

    public int getServerTimeout();

    @NotNull
    public String getCharsetName();

    default public Charset getConsoleCharset() {
        String charsetName = this.getCharsetName();
        if (StringUtil.isEmptyOrSpaces((String)charsetName) || charsetName.equals(PerforcePhysicalConnectionParametersI.getCharsetNone())) {
            return EncodingManager.getInstance().getDefaultConsoleEncoding();
        }
        if (charsetName.startsWith("utf16") || charsetName.startsWith("utf32")) {
            return StandardCharsets.UTF_8;
        }
        try {
            return Charset.forName(charsetName);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
            return StandardCharsets.UTF_8;
        }
    }

    @NlsSafe
    public static String getCharsetNone() {
        return PerforceBundle.message("none.charset.presentation", new Object[0]);
    }
}

