/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.mechanism;

import zmq.Msg;
import zmq.Options;
import zmq.io.SessionBase;
import zmq.io.mechanism.Mechanism;
import zmq.io.mechanism.Mechanisms;
import zmq.io.net.Address;

class NullMechanism
extends Mechanism {
    private static final String OK = "200";
    private static final String READY = "READY";
    private static final String ERROR = "ERROR";
    private boolean readyCommandSent;
    private boolean errorCommandSent;
    private boolean readyCommandReceived;
    private boolean errorCommandReceived;
    private boolean zapConnected;
    private boolean zapRequestSent;
    private boolean zapReplyReceived;

    NullMechanism(SessionBase session, Address peerAddress, Options options) {
        super(session, peerAddress, options);
        if (options.zapDomain != null && !options.zapDomain.isEmpty() && session.zapConnect() == 0) {
            this.zapConnected = true;
        }
    }

    @Override
    public int nextHandshakeCommand(Msg msg) {
        if (this.readyCommandSent || this.errorCommandSent) {
            return 35;
        }
        if (this.zapConnected && !this.zapReplyReceived) {
            if (this.zapRequestSent) {
                return 35;
            }
            this.sendZapRequest(Mechanisms.NULL, false);
            this.zapRequestSent = true;
            int rc = this.receiveAndProcessZapReply();
            if (rc != 0) {
                return rc;
            }
            this.zapReplyReceived = true;
        }
        if (this.zapReplyReceived && !OK.equals(this.statusCode)) {
            msg.putShortString(ERROR);
            msg.putShortString(this.statusCode);
            this.errorCommandSent = true;
            return 0;
        }
        msg.putShortString(READY);
        String socketType = this.socketType();
        this.addProperty(msg, "Socket-Type", socketType);
        if (this.options.type == 3 || this.options.type == 5 || this.options.type == 6) {
            this.addProperty(msg, "Identity", this.options.identity);
        }
        this.readyCommandSent = true;
        return 0;
    }

    @Override
    public int processHandshakeCommand(Msg msg) {
        int rc;
        if (this.readyCommandReceived || this.errorCommandReceived) {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000001);
            return 156384820;
        }
        int dataSize = msg.size();
        if (dataSize >= 6 && this.compare(msg, READY, true)) {
            rc = this.processReadyCommand(msg);
        } else if (dataSize >= 6 && this.compare(msg, ERROR, true)) {
            rc = this.processErrorCommand(msg);
        } else {
            this.session.getSocket().eventHandshakeFailedProtocol(this.session.getEndpoint(), 0x10000001);
            return 156384820;
        }
        return rc;
    }

    private int processReadyCommand(Msg msg) {
        this.readyCommandReceived = true;
        return this.parseMetadata(msg, 6, false);
    }

    private int processErrorCommand(Msg msg) {
        this.errorCommandReceived = true;
        return this.parseErrorMessage(msg);
    }

    @Override
    public int zapMsgAvailable() {
        if (this.zapReplyReceived) {
            return 156384763;
        }
        int rc = this.receiveAndProcessZapReply();
        if (rc == 0) {
            this.zapReplyReceived = true;
        }
        return rc;
    }

    @Override
    public Mechanism.Status status() {
        boolean commandReceived;
        boolean commandSent = this.readyCommandSent || this.errorCommandSent;
        boolean bl = commandReceived = this.readyCommandReceived || this.errorCommandReceived;
        if (this.readyCommandSent && this.readyCommandReceived) {
            return Mechanism.Status.READY;
        }
        if (commandSent && commandReceived) {
            return Mechanism.Status.ERROR;
        }
        return Mechanism.Status.HANDSHAKING;
    }
}

