/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class AttributeMap
implements Serializable,
Cloneable {
    private static final Logger logger = Logger.getLogger(AttributeMap.class.getName());
    private static final long serialVersionUID = -7442871030874215436L;
    private static final String[] EMPTY_NAMESPACES = new String[0];
    private String[] namespacesArray;
    private HashMap namespaces;
    private boolean readOnly;
    private long changeTracker;

    public AttributeMap() {
    }

    public AttributeMap(AttributeMap attributeMap) {
        if (attributeMap == null) {
            return;
        }
        if (attributeMap.namespaces == null) {
            return;
        }
        this.copyInto(attributeMap);
    }

    protected void copyInto(AttributeMap attributeMap) {
        this.changeTracker = attributeMap.changeTracker;
        this.namespaces = (HashMap)attributeMap.namespaces.clone();
        for (Map.Entry entry : this.namespaces.entrySet()) {
            HashMap hashMap = (HashMap)entry.getValue();
            entry.setValue(hashMap.clone());
        }
    }

    public AttributeMap createUnmodifiableMap() {
        if (this.readOnly) {
            return this;
        }
        try {
            AttributeMap attributeMap = (AttributeMap)super.clone();
            attributeMap.readOnly = true;
            return attributeMap;
        }
        catch (Exception exception) {
            logger.severe("Clone failed for ReportAttributeMap.createUnmodifiableMap:" + exception);
            throw new IllegalStateException("Clone failed for ReportAttributeMap.createUnmodifiableMap");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AttributeMap attributeMap = (AttributeMap)super.clone();
        attributeMap.namespaces = (HashMap)this.namespaces.clone();
        for (Map.Entry entry : attributeMap.namespaces.entrySet()) {
            HashMap hashMap = (HashMap)entry.getValue();
            entry.setValue(hashMap.clone());
        }
        return attributeMap;
    }

    public Object setAttribute(String string, String string2, Object object) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("This collection is marked as read-only");
        }
        Object object2 = this.setAttributeInternal(string, string2, object);
        if (!ObjectUtilities.equal((Object)object2, (Object)object)) {
            ++this.changeTracker;
        }
        return object2;
    }

    protected Object setAttributeInternal(String string, String string2, Object object) {
        HashMap hashMap;
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if ((hashMap = (HashMap)this.namespaces.get(string)) == null) {
            if (object == null) {
                return null;
            }
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put(string2, object);
            this.namespacesArray = null;
            return this.namespaces.put(string, hashMap2);
        }
        if (object == null) {
            hashMap.remove(string2);
            if (hashMap.isEmpty()) {
                this.namespacesArray = null;
                this.namespaces.remove(string);
            }
            return null;
        }
        return hashMap.put(string2, object);
    }

    public boolean isEmpty() {
        if (this.namespaces == null) {
            return true;
        }
        return this.namespaces.isEmpty();
    }

    public Object getAttribute(String string, String string2) {
        if (this.namespaces == null) {
            return null;
        }
        HashMap hashMap = (HashMap)this.namespaces.get(string);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(string2);
    }

    public Object getFirstAttribute(String string) {
        if (this.namespaces == null) {
            return null;
        }
        for (Map.Entry entry : this.namespaces.entrySet()) {
            HashMap hashMap = (HashMap)entry.getValue();
            Object v = hashMap.get(string);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public Map getAttributes(String string) {
        if (this.namespaces == null) {
            return null;
        }
        HashMap hashMap = (HashMap)this.namespaces.get(string);
        if (hashMap == null) {
            return null;
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public String[] getNameSpaces() {
        if (this.namespaces == null) {
            return EMPTY_NAMESPACES;
        }
        if (this.namespacesArray != null) {
            return (String[])this.namespacesArray.clone();
        }
        this.namespacesArray = this.namespaces.keySet().toArray(new String[this.namespaces.size()]);
        return (String[])this.namespacesArray.clone();
    }

    public void makeReadOnly() {
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public long getChangeTracker() {
        return this.changeTracker;
    }
}

