/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectOutput;
import org.apache.derby.iapi.types.StreamHeaderGenerator;

public final class CharStreamHeaderGenerator
implements StreamHeaderGenerator {
    private static final byte[] DERBY_EOF_MARKER = new byte[]{-32, 0, 0};
    private static final int MAX_ENCODABLE_LENGTH = 65535;

    @Override
    public boolean expectsCharCount() {
        return false;
    }

    public static int writeEOFMarker(byte[] buffer, int offset) {
        System.arraycopy(DERBY_EOF_MARKER, 0, buffer, offset, DERBY_EOF_MARKER.length);
        return DERBY_EOF_MARKER.length;
    }

    public static int writeEOFMarker(ObjectOutput out) throws IOException {
        out.write(DERBY_EOF_MARKER);
        return DERBY_EOF_MARKER.length;
    }

    @Override
    public int generateInto(byte[] buffer, int offset, long byteLength) {
        if (byteLength > 0L && byteLength <= 65535L) {
            buffer[offset] = (byte)(byteLength >>> 8);
            buffer[offset + 1] = (byte)(byteLength >>> 0);
        } else {
            buffer[offset] = 0;
            buffer[offset + 1] = 0;
        }
        return 2;
    }

    @Override
    public int generateInto(ObjectOutput out, long byteLength) throws IOException {
        if (byteLength > 0L && byteLength <= 65535L) {
            out.writeByte((byte)(byteLength >>> 8));
            out.writeByte((byte)(byteLength >>> 0));
        } else {
            out.writeByte(0);
            out.writeByte(0);
        }
        return 2;
    }

    @Override
    public int writeEOF(byte[] buffer, int offset, long byteLength) {
        if (byteLength < 0L || byteLength > 65535L) {
            System.arraycopy(DERBY_EOF_MARKER, 0, buffer, offset, DERBY_EOF_MARKER.length);
            return DERBY_EOF_MARKER.length;
        }
        return 0;
    }

    @Override
    public int writeEOF(ObjectOutput out, long byteLength) throws IOException {
        if (byteLength < 0L || byteLength > 65535L) {
            out.write(DERBY_EOF_MARKER);
            return DERBY_EOF_MARKER.length;
        }
        return 0;
    }

    @Override
    public int getMaxHeaderLength() {
        return 2;
    }
}

