/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public abstract class SVGAttributedFigure
extends AbstractAttributedFigure {
    @Override
    public void draw(Graphics2D graphics2D) {
        double d = this.get(SVGAttributeKeys.OPACITY);
        if ((d = Math.min(Math.max(0.0, d), 1.0)) != 0.0) {
            if (d != 1.0) {
                Rectangle2D.Double double_ = this.getDrawingArea();
                Rectangle rectangle = graphics2D.getClipBounds();
                if (rectangle != null) {
                    Rectangle2D.intersect(double_, rectangle, double_);
                }
                if (!double_.isEmpty()) {
                    BufferedImage bufferedImage = new BufferedImage(Math.max(1, (int)((2.0 + double_.width) * graphics2D.getTransform().getScaleX())), Math.max(1, (int)((2.0 + double_.height) * graphics2D.getTransform().getScaleY())), 2);
                    Graphics2D graphics2D2 = bufferedImage.createGraphics();
                    graphics2D2.scale(graphics2D.getTransform().getScaleX(), graphics2D.getTransform().getScaleY());
                    graphics2D2.translate((int)(-double_.x), (int)(-double_.y));
                    graphics2D2.setRenderingHints(graphics2D.getRenderingHints());
                    this.drawFigure(graphics2D2);
                    graphics2D2.dispose();
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, (float)d));
                    graphics2D.drawImage(bufferedImage, (int)double_.x, (int)double_.y, 2 + (int)double_.width, 2 + (int)double_.height, null);
                    graphics2D.setComposite(composite);
                }
            } else {
                this.drawFigure(graphics2D);
            }
        }
    }

    public void drawFigure(Graphics2D graphics2D) {
        Paint paint;
        AffineTransform affineTransform = null;
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            affineTransform = graphics2D.getTransform();
            graphics2D.transform((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM));
        }
        if ((paint = SVGAttributeKeys.getFillPaint(this)) != null) {
            graphics2D.setPaint(paint);
            this.drawFill(graphics2D);
        }
        if ((paint = SVGAttributeKeys.getStrokePaint(this)) != null && (Double)this.get(SVGAttributeKeys.STROKE_WIDTH) > 0.0) {
            graphics2D.setPaint(paint);
            graphics2D.setStroke(SVGAttributeKeys.getStroke(this));
            this.drawStroke(graphics2D);
        }
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            graphics2D.setTransform(affineTransform);
        }
    }

    @Override
    public <T> void set(AttributeKey<T> attributeKey, T t) {
        if (attributeKey == SVGAttributeKeys.TRANSFORM) {
            this.invalidate();
        }
        super.set(attributeKey, t);
    }

    @Override
    public Collection<Action> getActions(Point2D.Double double_) {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        if (this.get(SVGAttributeKeys.TRANSFORM) != null) {
            ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
            linkedList.add(new AbstractAction(resourceBundleUtil.getString("edit.removeTransform.text")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                    SVGAttributedFigure.this.willChange();
                    SVGAttributedFigure.this.fireUndoableEditHappened(SVGAttributeKeys.TRANSFORM.setUndoable(SVGAttributedFigure.this, null));
                    SVGAttributedFigure.this.changed();
                }
            });
        }
        return linkedList;
    }

    @Override
    public final void write(DOMOutput dOMOutput) throws IOException {
        throw new UnsupportedOperationException("Use SVGStorableOutput to write this Figure.");
    }

    @Override
    public final void read(DOMInput dOMInput) throws IOException {
        throw new UnsupportedOperationException("Use SVGStorableInput to read this Figure.");
    }
}

