/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import javax.xml.crypto.test.SimpleKSResult;

public class KeySelectors {

    public static class ByteUtil {
        private static String mapping = "0123456789ABCDEF";
        private static int numBytesPerRow = 6;

        private static String getHex(byte by) {
            int n = by & 0xF;
            int n2 = by >> 4 & 0xF;
            char[] cArray = new char[]{mapping.charAt(n2), mapping.charAt(n)};
            return new String(cArray);
        }

        public static String dumpArray(byte[] byArray) {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer(512);
            stringBuffer.append("{");
            for (int i = 0; i < byArray.length / numBytesPerRow; ++i) {
                for (int j = 0; j < numBytesPerRow; ++j) {
                    stringBuffer.append("(byte)0x" + ByteUtil.getHex(byArray[i * numBytesPerRow + j]) + ", ");
                }
                n += numBytesPerRow;
            }
            while (n < byArray.length) {
                stringBuffer.append("(byte)0x" + ByteUtil.getHex(byArray[n]) + " ");
                ++n;
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    public static class CollectionKeySelector
    extends KeySelector {
        private CertificateFactory certFac;
        private File certDir;
        private Vector certs;
        private static final int MATCH_SUBJECT = 0;
        private static final int MATCH_ISSUER = 1;
        private static final int MATCH_SERIAL = 2;
        private static final int MATCH_SUBJECT_KEY_ID = 3;
        private static final int MATCH_CERTIFICATE = 4;

        public CollectionKeySelector(File file) {
            this.certDir = file;
            try {
                this.certFac = CertificateFactory.getInstance("X509");
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            this.certs = new Vector();
            File[] fileArray = new File(this.certDir, "certs").listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    this.certs.add((X509Certificate)this.certFac.generateCertificate(new FileInputStream(fileArray[i])));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public Vector match(int n, Object object, Vector vector) {
            Vector<X509Certificate> vector2 = new Vector<X509Certificate>();
            block7: for (int i = 0; i < vector.size(); ++i) {
                X509Certificate x509Certificate = (X509Certificate)vector.get(i);
                switch (n) {
                    case 0: {
                        X500Principal x500Principal = new X500Principal((String)object);
                        if (!x509Certificate.getSubjectX500Principal().equals(x500Principal)) continue block7;
                        vector2.add(x509Certificate);
                        continue block7;
                    }
                    case 1: {
                        X500Principal x500Principal = new X500Principal((String)object);
                        if (!x509Certificate.getIssuerX500Principal().equals(x500Principal)) continue block7;
                        vector2.add(x509Certificate);
                        continue block7;
                    }
                    case 2: {
                        if (!x509Certificate.getSerialNumber().equals(object)) continue block7;
                        vector2.add(x509Certificate);
                        continue block7;
                    }
                    case 3: {
                        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.14");
                        if (byArray == null) continue block7;
                        byte[] byArray2 = new byte[byArray.length - 4];
                        System.arraycopy(byArray, 4, byArray2, 0, byArray2.length);
                        if (!Arrays.equals(byArray2, (byte[])object)) continue block7;
                        vector2.add(x509Certificate);
                        continue block7;
                    }
                    case 4: {
                        if (!x509Certificate.equals(object)) continue block7;
                        vector2.add(x509Certificate);
                    }
                }
            }
            return vector2;
        }

        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Null KeyInfo object!");
            }
            Iterator<XMLStructure> iterator = keyInfo.getContent().iterator();
            while (iterator.hasNext()) {
                XMLStructure xMLStructure = iterator.next();
                try {
                    int n;
                    if (xMLStructure instanceof KeyName) {
                        String string = ((KeyName)xMLStructure).getName();
                        PublicKey publicKey = null;
                        try {
                            File file = new File(new File(this.certDir, "certs"), string.toLowerCase() + ".crt");
                            X509Certificate x509Certificate = (X509Certificate)this.certFac.generateCertificate(new FileInputStream(file));
                            publicKey = x509Certificate.getPublicKey();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            int n2;
                            Vector vector = this.match(0, string, this.certs);
                            int n3 = n2 = vector == null ? 0 : vector.size();
                            if (n2 != 1) {
                                throw new KeySelectorException((n2 == 0 ? "No" : "More than one") + " match found");
                            }
                            publicKey = ((X509Certificate)vector.get(0)).getPublicKey();
                        }
                        return new SimpleKSResult(publicKey);
                    }
                    if (xMLStructure instanceof RetrievalMethod) {
                        RetrievalMethod retrievalMethod = (RetrievalMethod)xMLStructure;
                        String string = retrievalMethod.getType();
                        if (string.equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                            String string2 = retrievalMethod.getURI();
                            X509Certificate x509Certificate = (X509Certificate)this.certFac.generateCertificate(new FileInputStream(new File(this.certDir, string2)));
                            return new SimpleKSResult(x509Certificate.getPublicKey());
                        }
                        throw new KeySelectorException("Unsupported RetrievalMethod type");
                    }
                    if (!(xMLStructure instanceof X509Data)) continue;
                    List<?> list = ((X509Data)xMLStructure).getContent();
                    int n4 = list.size();
                    Vector vector = null;
                    for (n = 0; n < n4; ++n) {
                        Object obj = list.get(n);
                        if (obj instanceof String) {
                            vector = this.match(0, obj, this.certs);
                            continue;
                        }
                        if (obj instanceof byte[]) {
                            vector = this.match(3, obj, this.certs);
                            continue;
                        }
                        if (obj instanceof X509Certificate) {
                            vector = this.match(4, obj, this.certs);
                            continue;
                        }
                        if (obj instanceof X509IssuerSerial) {
                            X509IssuerSerial x509IssuerSerial = (X509IssuerSerial)obj;
                            vector = this.match(2, x509IssuerSerial.getSerialNumber(), this.certs);
                            vector = this.match(1, x509IssuerSerial.getIssuerName(), vector);
                            continue;
                        }
                        throw new KeySelectorException("Unsupported X509Data: " + obj);
                    }
                    int n5 = n = vector == null ? 0 : vector.size();
                    if (n != 1) {
                        throw new KeySelectorException((n == 0 ? "No" : "More than one") + " match found");
                    }
                    return new SimpleKSResult(((X509Certificate)vector.get(0)).getPublicKey());
                }
                catch (Exception exception) {
                    throw new KeySelectorException(exception);
                }
            }
            throw new KeySelectorException("No matching key found!");
        }
    }

    public static class KeyValueKeySelector
    extends KeySelector {
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Null KeyInfo object!");
            }
            SignatureMethod signatureMethod = (SignatureMethod)algorithmMethod;
            List<XMLStructure> list = keyInfo.getContent();
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xMLStructure = list.get(i);
                if (!(xMLStructure instanceof KeyValue)) continue;
                PublicKey publicKey = null;
                try {
                    publicKey = ((KeyValue)xMLStructure).getPublicKey();
                }
                catch (KeyException keyException) {
                    throw new KeySelectorException(keyException);
                }
                if (!KeyValueKeySelector.algEquals(signatureMethod.getAlgorithm(), publicKey.getAlgorithm())) continue;
                return new SimpleKSResult(publicKey);
            }
            throw new KeySelectorException("No KeyValue element found!");
        }

        static boolean algEquals(String string, String string2) {
            if (string2.equalsIgnoreCase("DSA") && string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                return true;
            }
            return string2.equalsIgnoreCase("RSA") && string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }

    public static class RawX509KeySelector
    extends KeySelector {
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Null KeyInfo object!");
            }
            Iterator<XMLStructure> iterator = keyInfo.getContent().iterator();
            while (iterator.hasNext()) {
                XMLStructure xMLStructure = iterator.next();
                if (!(xMLStructure instanceof X509Data)) continue;
                X509Data x509Data = (X509Data)xMLStructure;
                Object[] objectArray = x509Data.getContent().toArray();
                X509CRL x509CRL = null;
                for (int i = 0; i < objectArray.length && x509CRL == null; ++i) {
                    if (!(objectArray[i] instanceof X509CRL)) continue;
                    x509CRL = (X509CRL)objectArray[i];
                }
                Iterator<?> iterator2 = x509Data.getContent().iterator();
                while (iterator2.hasNext()) {
                    Object obj = iterator2.next();
                    if (!(obj instanceof X509Certificate) || purpose != KeySelector.Purpose.VERIFY && x509CRL != null && x509CRL.isRevoked((X509Certificate)obj)) continue;
                    return new SimpleKSResult(((X509Certificate)obj).getPublicKey());
                }
            }
            throw new KeySelectorException("No X509Certificate found!");
        }
    }

    public static class SecretKeySelector
    extends KeySelector {
        private SecretKey key;

        public SecretKeySelector(byte[] byArray) {
            this.key = this.wrapBytes(byArray);
        }

        public SecretKeySelector(SecretKey secretKey) {
            this.key = secretKey;
        }

        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            return new SimpleKSResult(this.key);
        }

        private SecretKey wrapBytes(byte[] byArray) {
            return new SecretKey(this, byArray){
                private final /* synthetic */ byte[] val$bytes;
                private final /* synthetic */ SecretKeySelector this$0;
                {
                    this.this$0 = secretKeySelector;
                    this.val$bytes = byArray;
                }

                public String getFormat() {
                    return "RAW";
                }

                public String getAlgorithm() {
                    return "Secret key";
                }

                public byte[] getEncoded() {
                    return (byte[])this.val$bytes.clone();
                }
            };
        }
    }
}

