/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.FPLocationCompleter;
import org.jboss.galleon.universe.FeaturePackLocation;

@CommandDefinition(name="new", description="New provisioning state. You can add an initial feature-pack when creating an empty state.")
public class StateNewCommand
extends PmSessionCommand {
    @Option(name="feature-pack-location", completer=FPLocationCompleter.class, required=false, description="Feature pack location")
    protected String fpl;
    @Option(name="default-configs-inherit", required=false, hasValue=false, description="Include the default configurations defined in this feature pack. By default they are not included")
    Boolean inheritConfigs;
    @Option(name="packages-inherit", required=false, hasValue=false, description="Include the default packages defined in this feature pack. By default they are not included")
    Boolean inheritPackages;

    public Boolean isInheritConfigs() {
        return this.inheritConfigs;
    }

    public Boolean isInheritPackages() {
        return this.inheritPackages;
    }

    public FeaturePackLocation getFpl() {
        if (this.fpl == null) {
            return null;
        }
        return FeaturePackLocation.fromString(this.fpl);
    }

    @Override
    protected String getCoreVersion(PmSession session) throws ProvisioningException {
        FeaturePackLocation loc = this.getFpl();
        if (loc == null) {
            return null;
        }
        if (loc.getUniverse() == null) {
            loc = new FeaturePackLocation(session.getUniverse().getBuiltinUniverseSpec(), loc.getProducerName(), loc.getChannelName(), loc.getFrequency(), loc.getBuild());
        }
        return session.getGalleonBuilder().getCoreVersion(loc);
    }

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        throw new CommandExecutionException("Shouldn't have been called");
    }

    @Override
    public String getCommandClassName(PmSession session) throws ProvisioningException {
        return "org.jboss.galleon.cli.cmd.state.core.CoreStateNewCommand";
    }
}

