/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import jdk.jfr.EventType;
import jdk.jfr.Timespan;
import jdk.jfr.Timestamp;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.consumer.RecordingFile;
import jdk.jfr.internal.consumer.RecordingInternals;
import jdk.jfr.internal.tool.StructuredWriter;

abstract class EventPrintWriter
extends StructuredWriter {
    protected static final String STACK_TRACE_FIELD = "stackTrace";
    protected static final String EVENT_THREAD_FIELD = "eventThread";
    private Predicate<EventType> eventFilter = eventType -> true;
    private int stackDepth;
    private Map<ValueDescriptor, ValueType> typeOfValues = new HashMap<ValueDescriptor, ValueType>();

    EventPrintWriter(PrintWriter printWriter) {
        super(printWriter);
    }

    protected abstract void print(List<RecordedEvent> var1);

    void print(Path path) throws FileNotFoundException, IOException {
        ArrayList<RecordedEvent> arrayList = new ArrayList<RecordedEvent>(500000);
        this.printBegin();
        try (RecordingFile recordingFile = new RecordingFile(path);){
            while (recordingFile.hasMoreEvents()) {
                RecordedEvent recordedEvent = recordingFile.readEvent();
                if (this.acceptEvent(recordedEvent)) {
                    arrayList.add(recordedEvent);
                }
                if (!RecordingInternals.INSTANCE.isLastEventInChunk(recordingFile)) continue;
                RecordingInternals.INSTANCE.sort(arrayList);
                this.print(arrayList);
                arrayList.clear();
            }
        }
        this.printEnd();
        this.flush(true);
    }

    protected void printEnd() {
    }

    protected void printBegin() {
    }

    public final void setEventFilter(Predicate<EventType> predicate) {
        this.eventFilter = predicate;
    }

    protected final boolean acceptEvent(RecordedEvent recordedEvent) {
        return this.eventFilter.test(recordedEvent.getEventType());
    }

    protected final int getStackDepth() {
        return this.stackDepth;
    }

    protected final boolean isLateField(String string) {
        return string.equals(EVENT_THREAD_FIELD) || string.equals(STACK_TRACE_FIELD);
    }

    public void setStackDepth(int n) {
        this.stackDepth = n;
    }

    protected Object getValue(RecordedObject recordedObject, ValueDescriptor valueDescriptor) {
        ValueType valueType = this.typeOfValues.get(valueDescriptor);
        if (valueType == null) {
            valueType = this.determineValueType(valueDescriptor);
            this.typeOfValues.put(valueDescriptor, valueType);
        }
        switch (valueType) {
            case TIMESPAN: {
                return recordedObject.getDuration(valueDescriptor.getName());
            }
            case TIMESTAMP: {
                return RecordingInternals.INSTANCE.getOffsetDataTime(recordedObject, valueDescriptor.getName());
            }
        }
        return recordedObject.getValue(valueDescriptor.getName());
    }

    private ValueType determineValueType(ValueDescriptor valueDescriptor) {
        if (valueDescriptor.getAnnotation(Timespan.class) != null) {
            return ValueType.TIMESPAN;
        }
        if (valueDescriptor.getAnnotation(Timestamp.class) != null) {
            return ValueType.TIMESTAMP;
        }
        return ValueType.OTHER;
    }

    static enum ValueType {
        TIMESPAN,
        TIMESTAMP,
        OTHER;

    }
}

