/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.HSBType;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.types.Command;
import org.openhab.core.types.PrimitiveType;
import org.openhab.core.types.State;

@NonNullByDefault
public enum OnOffType implements PrimitiveType,
State,
Command
{
    ON,
    OFF;


    public static OnOffType from(String state) {
        return OnOffType.from("ON".equalsIgnoreCase(state) || "1".equalsIgnoreCase(state));
    }

    public static OnOffType from(boolean state) {
        return state ? ON : OFF;
    }

    @Override
    public String format(String pattern) {
        return String.format(pattern, this.toString());
    }

    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        return super.toString();
    }

    @Override
    public <T extends State> @Nullable T as(@Nullable Class<T> target) {
        if (target == DecimalType.class) {
            return (T)((State)target.cast(this == ON ? new DecimalType(1) : DecimalType.ZERO));
        }
        if (target == PercentType.class) {
            return (T)((State)target.cast(this == ON ? PercentType.HUNDRED : PercentType.ZERO));
        }
        if (target == HSBType.class) {
            return (T)((State)target.cast(this == ON ? HSBType.WHITE : HSBType.BLACK));
        }
        return State.super.as(target);
    }
}

