/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.publish.pubrel;

import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.publish.pubrec.MqttPubRec;
import com.hivemq.client.internal.mqtt.message.publish.pubrel.MqttPubRel;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperties;
import com.hivemq.client.mqtt.mqtt5.message.publish.pubrel.Mqtt5PubRelBuilder;
import com.hivemq.client.mqtt.mqtt5.message.publish.pubrel.Mqtt5PubRelReasonCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MqttPubRelBuilder
implements Mqtt5PubRelBuilder {
    private final int packetIdentifier;
    @NotNull
    private Mqtt5PubRelReasonCode reasonCode = MqttPubRel.DEFAULT_REASON_CODE;
    @Nullable
    private MqttUtf8StringImpl reasonString;
    @NotNull
    private MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.NO_USER_PROPERTIES;

    public MqttPubRelBuilder(@NotNull MqttPubRec pubRec) {
        this.packetIdentifier = pubRec.getPacketIdentifier();
    }

    @NotNull
    public MqttPubRelBuilder reasonCode(@NotNull Mqtt5PubRelReasonCode reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Override
    @NotNull
    public MqttPubRelBuilder reasonString(@Nullable String reasonString) {
        this.reasonString = MqttChecks.reasonString(reasonString);
        return this;
    }

    @Override
    @NotNull
    public MqttPubRelBuilder reasonString(@Nullable MqttUtf8String reasonString) {
        this.reasonString = MqttChecks.reasonString(reasonString);
        return this;
    }

    @Override
    @NotNull
    public MqttPubRelBuilder userProperties(@Nullable Mqtt5UserProperties userProperties) {
        this.userProperties = MqttChecks.userProperties(userProperties);
        return this;
    }

    public @NotNull MqttUserPropertiesImplBuilder.Nested<MqttPubRelBuilder> userProperties() {
        return new MqttUserPropertiesImplBuilder.Nested<MqttPubRelBuilder>(this.userProperties, this::userProperties);
    }

    @Override
    @NotNull
    public Mqtt5PubRelReasonCode getReasonCode() {
        return this.reasonCode;
    }

    @NotNull
    public MqttPubRel build() {
        return new MqttPubRel(this.packetIdentifier, this.reasonCode, this.reasonString, this.userProperties);
    }
}

