/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.NlsString;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.RelevanceQuery;
import shaded.com.google.common.collect.ImmutableMap;

abstract class MultiFieldQuery<T extends QueryBuilder>
extends RelevanceQuery<T> {
    public MultiFieldQuery(Map<String, RelevanceQuery.QueryBuilderStep<T>> queryBuildActions) {
        super(queryBuildActions);
    }

    @Override
    public T createQueryBuilder(List<NamedArgumentExpression> arguments) {
        NamedArgumentExpression fields = arguments.stream().filter(a -> a.getArgName().equalsIgnoreCase("fields")).findFirst().orElseThrow(() -> new SemanticCheckException("'fields' parameter is missing."));
        NamedArgumentExpression query = arguments.stream().filter(a -> a.getArgName().equalsIgnoreCase("query")).findFirst().orElseThrow(() -> new SemanticCheckException("'query' parameter is missing"));
        ImmutableMap fieldsAndWeights = (ImmutableMap)fields.getValue().valueOf().tupleValue().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (String)e.getKey(), e -> ((ExprValue)e.getValue()).floatValue()));
        return this.createBuilder((ImmutableMap<String, Float>)fieldsAndWeights, query.getValue().valueOf().stringValue());
    }

    protected abstract T createBuilder(ImmutableMap<String, Float> var1, String var2);

    public T build(RexCall fieldsRexCall, String query, Map<String, String> optionalArguments) {
        List fieldAndWeightNodes = fieldsRexCall.getOperands();
        ImmutableMap fields = (ImmutableMap)IntStream.range(0, fieldsRexCall.getOperands().size() / 2).map(i -> i * 2).mapToObj(i -> {
            RexLiteral fieldLiteral = (RexLiteral)fieldAndWeightNodes.get(i);
            RexLiteral weightLiteral = (RexLiteral)fieldAndWeightNodes.get(i + 1);
            String field = ((NlsString)Objects.requireNonNull(fieldLiteral.getValue())).getValue();
            Float weight = Float.valueOf(((Double)Objects.requireNonNull(weightLiteral.getValue())).floatValue());
            return Map.entry(field, weight);
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        T queryBuilder = this.createBuilder((ImmutableMap<String, Float>)fields, query);
        return this.applyArguments(queryBuilder, optionalArguments);
    }
}

